/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.executor;

import io.github.kosmx.emotes.common.SerializableConfig;
import io.github.kosmx.emotes.executor.Logger;
import io.github.kosmx.emotes.executor.dataTypes.IClientMethods;
import io.github.kosmx.emotes.executor.dataTypes.IDefaultTypes;
import io.github.kosmx.emotes.executor.dataTypes.IGetters;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public abstract class EmoteInstance {
    public static EmoteInstance instance = null;
    public static SerializableConfig config = null;

    public abstract Logger getLogger();

    public abstract IDefaultTypes getDefaults();

    public abstract IGetters getGetters();

    public abstract IClientMethods getClientMethods();

    public abstract boolean isClient();

    public abstract Path getGameDirectory();

    public File getExternalEmoteDir() {
        return this.getGameDirectory().resolve((String)EmoteInstance.config.emotesDir.get()).toFile();
    }

    public Path getConfigPath() {
        if (!Files.exists(this.getGameDirectory().resolve("config"), new LinkOption[0])) {
            try {
                Files.createDirectories(this.getGameDirectory().resolve("config"), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.getGameDirectory().resolve("config").resolve("emotecraft.json");
    }
}

