/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.sound;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.dsurround.config.data.SoundMetadataConfig;

@Environment(value=EnvType.CLIENT)
public final class SoundMetadata {
    private static final class_2561 NO_STRING = class_2585.field_24366;
    private final class_2561 title;
    private final class_2561 caption;
    private final List<class_2561> credits;

    public SoundMetadata() {
        this.title = NO_STRING;
        this.caption = NO_STRING;
        this.credits = ImmutableList.of();
    }

    public SoundMetadata(SoundMetadataConfig cfg) {
        Objects.requireNonNull(cfg);
        this.title = cfg.title.isPresent() ? new class_2588(cfg.title.get()) : NO_STRING;
        Object object = this.caption = cfg.caption.isPresent() ? new class_2588(cfg.caption.get()) : NO_STRING;
        if (cfg.credits == null || cfg.credits.size() == 0) {
            this.credits = ImmutableList.of();
        } else {
            this.credits = new ArrayList<class_2561>();
            for (String s : cfg.credits) {
                if (StringUtils.isEmpty((CharSequence)s)) {
                    this.credits.add(NO_STRING);
                    continue;
                }
                this.credits.add((class_2561)new class_2585(s));
            }
        }
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public class_2561 getCaption() {
        return this.caption;
    }

    public List<class_2561> getCredits() {
        return this.credits;
    }
}

