/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.sound;

import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.gui.sound.ConfigSoundInstance;
import org.orecruncher.dsurround.lib.TickCounter;
import org.orecruncher.dsurround.sound.ISoundFactory;
import org.orecruncher.dsurround.sound.MinecraftAudioPlayer;
import org.orecruncher.dsurround.sound.SoundFactoryBuilder;

@Environment(value=EnvType.CLIENT)
public final class SoundInstanceHandler {
    private static final Object2LongOpenHashMap<class_2960> soundCull = new Object2LongOpenHashMap(32);
    private static final Set<class_2960> thunderSounds = new HashSet<class_2960>();
    private static final ISoundFactory THUNDER_SOUND;

    private static boolean isSoundBlocked(class_2960 id) {
        return Client.SoundConfig.isBlocked(id);
    }

    private static boolean isSoundCulled(class_2960 id) {
        return Client.SoundConfig.isCulled(id);
    }

    private static boolean isSoundCulledLogical(class_2960 sound) {
        int cullInterval = Client.Config.soundSystem.cullInterval;
        if (cullInterval > 0 && SoundInstanceHandler.isSoundCulled(sound)) {
            long lastOccurrence = soundCull.getLong((Object)Objects.requireNonNull(sound));
            long currentTick = TickCounter.getTickCount();
            if (currentTick - lastOccurrence < (long)cullInterval) {
                return true;
            }
            soundCull.put((Object)sound, currentTick);
        }
        return false;
    }

    public static boolean shouldBlockSoundPlay(class_1113 theSound) {
        if (theSound instanceof ConfigSoundInstance) {
            return false;
        }
        class_2960 id = theSound.method_4775();
        if (Client.Config.thunderStorms.replaceThunderSounds && thunderSounds.contains(id)) {
            class_1109 sound = THUNDER_SOUND.createAtLocation(new class_243(theSound.method_4784(), theSound.method_4779(), theSound.method_4778()));
            MinecraftAudioPlayer.INSTANCE.play((class_1113)sound);
            return true;
        }
        return SoundInstanceHandler.isSoundBlocked(id) || SoundInstanceHandler.isSoundCulledLogical(id);
    }

    public static boolean inRange(class_243 listener, class_1113 sound, int pad) {
        if (sound.method_4787() || sound.method_4777() == class_1113.class_1114.field_5478 || sound.method_4786() || sound.method_4774() == class_3419.field_15252) {
            return true;
        }
        int distSq = sound.method_4776().method_4770() + pad;
        distSq *= distSq;
        return listener.method_1028(sound.method_4784(), sound.method_4779(), sound.method_4778()) < (double)distSq;
    }

    public static boolean inRange(class_243 listener, class_1113 sound) {
        return SoundInstanceHandler.inRange(listener, sound, 0);
    }

    static {
        thunderSounds.add(class_3417.field_14865.method_14833());
        THUNDER_SOUND = SoundFactoryBuilder.create(new class_2960("dsurround", "thunder")).category(class_3419.field_15252).volume(10000.0f).build();
    }
}

