/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.sound;

import com.google.common.base.MoreObjects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1106;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.config.SoundLibrary;
import org.orecruncher.dsurround.lib.math.MathStuff;
import org.orecruncher.dsurround.lib.random.XorShiftRandom;
import org.orecruncher.dsurround.sound.BackgroundSoundLoop;
import org.orecruncher.dsurround.sound.ISoundFactory;

@Environment(value=EnvType.CLIENT)
public final class SoundFactoryBuilder {
    private static final class_243 BLOCK_CENTER_ADJUST = new class_243(0.5, 0.5, 0.5);
    private final class_3414 soundEvent;
    private float minVolume = 1.0f;
    private float maxVolume = 1.0f;
    private float minPitch = 1.0f;
    private float maxPitch = 1.0f;
    private class_3419 category = class_3419.field_15256;
    private boolean isRepeatable = false;
    private int repeatDelay = 0;
    private boolean global = false;
    private class_1113.class_1114 attenuationType = class_1113.class_1114.field_5476;

    SoundFactoryBuilder(class_3414 soundEvent) {
        this.soundEvent = soundEvent;
    }

    public SoundFactoryBuilder volume(float vol) {
        this.minVolume = this.maxVolume = vol;
        return this;
    }

    public SoundFactoryBuilder volumeRange(float min, float max) {
        this.minVolume = min;
        this.maxVolume = max;
        return this;
    }

    public SoundFactoryBuilder pitch(float pitch) {
        this.minPitch = this.maxPitch = pitch;
        return this;
    }

    public SoundFactoryBuilder pitchRange(float min, float max) {
        this.minPitch = min;
        this.maxPitch = max;
        return this;
    }

    public SoundFactoryBuilder category(class_3419 category) {
        this.category = category;
        return this;
    }

    public SoundFactoryBuilder repeatable() {
        this.isRepeatable = true;
        this.repeatDelay = 0;
        return this;
    }

    public SoundFactoryBuilder repeatable(int delay) {
        this.isRepeatable = true;
        this.repeatDelay = delay;
        return this;
    }

    public SoundFactoryBuilder attenuation(class_1113.class_1114 attenuation) {
        this.attenuationType = attenuation;
        this.global = attenuation == class_1113.class_1114.field_5478;
        return this;
    }

    public SoundFactoryBuilder global() {
        this.attenuationType = class_1113.class_1114.field_5478;
        this.global = true;
        return this;
    }

    public ISoundFactory build() {
        return new Factory(this);
    }

    private float generate(float min, float max) {
        float delta = max - min;
        if (Float.compare(delta, 0.0f) == 0) {
            return min;
        }
        return (float)(XorShiftRandom.current().nextDouble() * (double)delta + (double)min);
    }

    private BackgroundSoundLoop createBackgroundSoundLoop() {
        return new BackgroundSoundLoop(this.soundEvent).setVolume(this.generate(this.minVolume, this.maxVolume)).setPitch(this.generate(this.minPitch, this.maxPitch));
    }

    private BackgroundSoundLoop createBackgroundSoundLoopAt(class_2338 pos) {
        return new BackgroundSoundLoop(this.soundEvent, pos).setVolume(this.generate(this.minVolume, this.maxVolume)).setPitch(this.generate(this.minPitch, this.maxPitch));
    }

    private class_1109 createAsAdditional() {
        return new class_1109(this.soundEvent.method_14833(), this.category, this.generate(this.minVolume, this.maxVolume), this.generate(this.minPitch, this.maxPitch), this.isRepeatable, this.repeatDelay, this.attenuationType, 0.0, 0.0, 0.0, true);
    }

    private class_1106 createAtEntity(class_1297 entity) {
        return new class_1106(this.soundEvent, this.category, this.generate(this.minVolume, this.maxVolume), this.generate(this.minPitch, this.maxPitch), entity);
    }

    private class_1109 createAtLocation(class_243 position) {
        return new class_1109(this.soundEvent.method_14833(), this.category, this.generate(this.minVolume, this.maxVolume), this.generate(this.minPitch, this.maxPitch), this.isRepeatable, this.repeatDelay, this.attenuationType, position.method_10216(), position.method_10214(), position.method_10215(), this.global);
    }

    public static SoundFactoryBuilder create(String soundEventId) {
        class_3414 se = SoundLibrary.getSound(soundEventId);
        return SoundFactoryBuilder.create(se);
    }

    public static SoundFactoryBuilder create(class_2960 soundEventId) {
        class_3414 se = SoundLibrary.getSound(soundEventId);
        return SoundFactoryBuilder.create(se);
    }

    public static SoundFactoryBuilder create(class_3414 soundEvent) {
        return new SoundFactoryBuilder(soundEvent);
    }

    private record Factory(SoundFactoryBuilder builder) implements Comparable<ISoundFactory>,
    ISoundFactory
    {
        @Override
        public class_3414 getSoundEvent() {
            return this.builder.soundEvent;
        }

        @Override
        public BackgroundSoundLoop createBackgroundSoundLoop() {
            return this.builder.createBackgroundSoundLoop();
        }

        @Override
        public BackgroundSoundLoop createBackgroundSoundLoopAt(class_2338 pos) {
            return this.builder.createBackgroundSoundLoopAt(pos);
        }

        @Override
        public class_1109 createAsMood(class_1297 entity, int minRange, int maxRange) {
            class_243 offset = MathStuff.randomPoint(minRange, maxRange);
            class_243 position = entity.method_33571().method_1019(offset);
            return this.builder.createAtLocation(position);
        }

        @Override
        public class_1109 createAsAdditional() {
            return this.builder.createAsAdditional();
        }

        @Override
        public class_1109 createAtLocation(class_2338 pos) {
            return this.builder.createAtLocation(class_243.method_24954((class_2382)pos).method_1019(BLOCK_CENTER_ADJUST));
        }

        @Override
        public class_1106 createAtEntity(class_1297 entity) {
            return this.builder.createAtEntity(entity);
        }

        @Override
        public class_1109 createAtLocation(class_243 position) {
            return this.builder.createAtLocation(position);
        }

        @Override
        public int hashCode() {
            return this.builder.soundEvent.hashCode();
        }

        @Override
        public int compareTo(@NotNull ISoundFactory o) {
            return this.builder.soundEvent.method_14833().method_12833(o.getSoundEvent().method_14833());
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("SoundEvent", (Object)this.builder.soundEvent.method_14833()).toString();
        }
    }
}

