/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.sound;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.runtime.audio.AudioUtilities;
import org.orecruncher.dsurround.sound.IAudioPlayer;

@Environment(value=EnvType.CLIENT)
public class MinecraftAudioPlayer
implements IAudioPlayer {
    private static final IModLog LOGGER = Client.LOGGER.createChild(MinecraftAudioPlayer.class);
    public static IAudioPlayer INSTANCE = new MinecraftAudioPlayer(GameUtils.getSoundHander());
    private final class_1144 manager;

    public MinecraftAudioPlayer(class_1144 manager) {
        this.manager = manager;
    }

    @Override
    public void play(class_1113 sound) {
        LOGGER.debug(1, () -> String.format("PLAYING %s", this.formatSound(sound)));
        this.manager.method_4873(sound);
    }

    @Override
    public void stop(class_1113 sound) {
        LOGGER.debug(1, () -> String.format("STOPPING %s", this.formatSound(sound)));
        this.manager.method_4870(sound);
    }

    @Override
    public void stopAll() {
        LOGGER.debug(1, "STOPPING all sounds", new Object[0]);
        this.manager.method_4881();
    }

    @Override
    public boolean isPlaying(class_1113 sound) {
        return this.manager.method_4877(sound);
    }

    protected String formatSound(class_1113 sound) {
        return AudioUtilities.debugString(sound);
    }
}

