/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.sets;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_638;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.Lazy;
import org.orecruncher.dsurround.lib.scripting.VariableSet;
import org.orecruncher.dsurround.lib.world.WorldUtils;
import org.orecruncher.dsurround.runtime.sets.IWeatherVariables;

@Environment(value=EnvType.CLIENT)
public class WeatherVariables
extends VariableSet<IWeatherVariables>
implements IWeatherVariables {
    private final Lazy<Float> temperature = new Lazy<Float>(() -> {
        if (GameUtils.isInGame()) {
            class_638 world = GameUtils.getWorld();
            class_2338 pos = GameUtils.getPlayer().method_24515();
            return Float.valueOf(WorldUtils.getTemperatureAt((class_1937)world, pos));
        }
        return Float.valueOf(0.0f);
    });
    private boolean isRaining;
    private boolean isThundering;
    private float rainIntensity;
    private float thunderIndensity;

    public WeatherVariables() {
        super("weather");
    }

    @Override
    public IWeatherVariables getInterface() {
        return this;
    }

    @Override
    public void update() {
        if (GameUtils.isInGame()) {
            class_638 world = GameUtils.getWorld();
            this.rainIntensity = world.method_8430(1.0f);
            this.thunderIndensity = world.method_8478(1.0f);
            this.isRaining = world.method_8419();
            this.isThundering = world.method_8546();
        } else {
            this.rainIntensity = 0.0f;
            this.thunderIndensity = 0.0f;
            this.isRaining = false;
            this.isThundering = false;
        }
        this.temperature.reset();
    }

    @Override
    public boolean isRaining() {
        return this.isRaining;
    }

    @Override
    public boolean isThundering() {
        return this.isThundering;
    }

    @Override
    public float getRainIntensity() {
        return this.rainIntensity;
    }

    @Override
    public float getThunderIntensity() {
        return this.thunderIndensity;
    }

    @Override
    public float getTemperature() {
        return this.temperature.get().floatValue();
    }
}

