/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.sets;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1291;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.Lazy;
import org.orecruncher.dsurround.lib.scripting.VariableSet;
import org.orecruncher.dsurround.lib.world.WorldUtils;
import org.orecruncher.dsurround.runtime.sets.IPlayerVariables;

@Environment(value=EnvType.CLIENT)
public class PlayerVariables
extends VariableSet<IPlayerVariables>
implements IPlayerVariables {
    private final Lazy<Boolean> isSuffocating = new Lazy<Boolean>(() -> {
        if (GameUtils.isInGame()) {
            class_1657 player = GameUtils.getPlayer();
            return !player.method_7337() && player.method_5669() < 0;
        }
        return false;
    });
    private final Lazy<Boolean> canSeeSky = new Lazy<Boolean>(() -> {
        if (GameUtils.isInGame()) {
            class_638 world = GameUtils.getWorld();
            class_1657 player = GameUtils.getPlayer();
            return world.method_8311(player.method_24515().method_10069(0, 2, 0));
        }
        return false;
    });
    private final Lazy<Boolean> canRainOn = new Lazy<Boolean>(() -> {
        class_1657 player;
        class_638 world;
        if (GameUtils.isInGame() && (world = GameUtils.getWorld()).method_8311((player = GameUtils.getPlayer()).method_24515().method_10069(0, 2, 0))) {
            return WorldUtils.getTopSolidOrLiquidBlock((class_1937)world, player.method_24515()).method_10264() <= player.method_24515().method_10264();
        }
        return false;
    });
    private boolean isCreative;
    private boolean isBurning;
    private boolean isFlying;
    private boolean isSprintnig;
    private boolean isInLava;
    private boolean isInvisible;
    private boolean isInWater;
    private boolean isWet;
    private boolean isRiding;
    private boolean isOnGround;
    private boolean isMoving;
    private float health;
    private float maxHealth;
    private float foodLevel;
    private float foodSaturationLevel;
    private double x;
    private double y;
    private double z;

    public PlayerVariables() {
        super("player");
    }

    @Override
    public void update() {
        if (GameUtils.isInGame()) {
            class_1657 player = GameUtils.getPlayer();
            assert (player != null);
            class_1702 hm = player.method_7344();
            this.isCreative = player.method_7337();
            this.isBurning = player.method_5809();
            this.isFlying = player.method_31549().field_7479;
            this.isSprintnig = player.method_5624();
            this.isInLava = player.method_5771();
            this.isInvisible = player.method_5767();
            this.isInWater = player.method_5869();
            this.isWet = player.method_5637();
            this.isRiding = player.method_5765();
            this.isOnGround = player.method_24828();
            this.isMoving = player.field_7483 != player.field_7505;
            this.health = player.method_6032();
            this.maxHealth = player.method_6063();
            this.foodLevel = hm.method_7586();
            this.foodSaturationLevel = hm.method_7589();
            this.x = player.method_23317();
            this.y = player.method_23318();
            this.z = player.method_23321();
        } else {
            this.isCreative = false;
            this.isBurning = false;
            this.isFlying = false;
            this.isSprintnig = false;
            this.isInLava = false;
            this.isInvisible = false;
            this.isInWater = false;
            this.isWet = false;
            this.isRiding = false;
            this.isOnGround = false;
            this.health = 20.0f;
            this.maxHealth = 20.0f;
            this.foodLevel = 20.0f;
            this.foodSaturationLevel = 20.0f;
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
        }
        this.isSuffocating.reset();
        this.canRainOn.reset();
        this.canSeeSky.reset();
    }

    @Override
    public IPlayerVariables getInterface() {
        return this;
    }

    @Override
    public boolean isCreative() {
        return this.isCreative;
    }

    @Override
    public boolean isBurning() {
        return this.isBurning;
    }

    @Override
    public boolean isSuffocating() {
        return this.isSuffocating.get();
    }

    @Override
    public boolean isFlying() {
        return this.isFlying;
    }

    @Override
    public boolean isSprintnig() {
        return this.isSprintnig;
    }

    @Override
    public boolean isInLava() {
        return this.isInLava;
    }

    @Override
    public boolean isInvisible() {
        return this.isInvisible;
    }

    @Override
    public boolean isInWater() {
        return this.isInWater;
    }

    @Override
    public boolean isMoving() {
        return this.isMoving;
    }

    @Override
    public boolean isWet() {
        return this.isWet;
    }

    @Override
    public boolean isRiding() {
        return this.isRiding;
    }

    @Override
    public boolean isOnGround() {
        return this.isOnGround;
    }

    @Override
    public boolean canRainOn() {
        return this.canRainOn.get();
    }

    @Override
    public boolean canSeeSky() {
        return this.canSeeSky.get();
    }

    @Override
    public float getHealth() {
        return this.health;
    }

    @Override
    public float getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public float getFoodLevel() {
        return this.foodLevel;
    }

    @Override
    public float getFoodSaturationLevel() {
        return this.foodSaturationLevel;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public boolean hasEffect(String effect) {
        try {
            class_2960 id = new class_2960(effect);
            class_1291 statusEffect = (class_1291)GameUtils.getRegistryManager().method_30530(class_2378.field_25104).method_10223(id);
            return GameUtils.getPlayer().method_6059(statusEffect);
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

