/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.sets;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import org.orecruncher.dsurround.lib.DayCycle;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.Lazy;
import org.orecruncher.dsurround.lib.scripting.VariableSet;
import org.orecruncher.dsurround.runtime.sets.IDiurnalVariables;

@Environment(value=EnvType.CLIENT)
public class DiurnalVariables
extends VariableSet<IDiurnalVariables>
implements IDiurnalVariables {
    private final Lazy<Float> moonPhaseFactor = new Lazy<Float>(() -> Float.valueOf(GameUtils.isInGame() ? DayCycle.getMoonSize((class_1937)GameUtils.getWorld()) : 0.0f));
    private final Lazy<Float> celestialAngle = new Lazy<Float>(() -> Float.valueOf(GameUtils.isInGame() ? GameUtils.getWorld().method_30274(0.0f) : 0.0f));
    private boolean isDay;
    private boolean isNight;
    private boolean isSunrise;
    private boolean isSunset;

    public DiurnalVariables() {
        super("diurnal");
    }

    @Override
    public IDiurnalVariables getInterface() {
        return this;
    }

    @Override
    public void update() {
        if (GameUtils.isInGame()) {
            DayCycle cycle = DayCycle.getCycle((class_1937)GameUtils.getWorld());
            this.isDay = cycle == DayCycle.DAYTIME;
            this.isNight = cycle == DayCycle.NIGHTTIME;
            this.isSunrise = cycle == DayCycle.SUNRISE;
            this.isSunset = cycle == DayCycle.SUNSET;
        } else {
            this.isDay = false;
            this.isNight = false;
            this.isSunrise = false;
            this.isSunset = false;
        }
        this.moonPhaseFactor.reset();
        this.celestialAngle.reset();
    }

    @Override
    public boolean isDay() {
        return this.isDay;
    }

    @Override
    public boolean isNight() {
        return this.isNight;
    }

    @Override
    public boolean isSunrise() {
        return this.isSunrise;
    }

    @Override
    public boolean isSunset() {
        return this.isSunset;
    }

    @Override
    public float getMoonPhaseFactor() {
        return this.moonPhaseFactor.get().floatValue();
    }

    @Override
    public float getCelestialAngle() {
        return this.celestialAngle.get().floatValue();
    }
}

