/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.sets;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1959;
import org.orecruncher.dsurround.config.BiomeLibrary;
import org.orecruncher.dsurround.config.biome.BiomeInfo;
import org.orecruncher.dsurround.config.biome.biometraits.BiomeTraits;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.Lazy;
import org.orecruncher.dsurround.lib.biome.BiomeUtils;
import org.orecruncher.dsurround.lib.scripting.VariableSet;
import org.orecruncher.dsurround.runtime.sets.IBiomeVariables;

@Environment(value=EnvType.CLIENT)
public class BiomeVariables
extends VariableSet<IBiomeVariables>
implements IBiomeVariables {
    private class_1959 biome;
    private final Lazy<String> category = new Lazy<String>(() -> this.biome.method_8688().method_8749());
    private final Lazy<String> precipitationType = new Lazy<String>(() -> this.biome.method_8694().method_8752());
    private BiomeInfo info;
    private final Lazy<String> name = new Lazy<String>(() -> this.info.getBiomeName());
    private final Lazy<String> modid = new Lazy<String>(() -> this.info.getBiomeId().method_12836());
    private final Lazy<String> id = new Lazy<String>(() -> this.info.getBiomeId().toString());
    private final Lazy<BiomeTraits> traits = new Lazy<BiomeTraits>(() -> this.info.getTraits());

    public BiomeVariables() {
        super("biome");
    }

    @Override
    public IBiomeVariables getInterface() {
        return this;
    }

    @Override
    public void update() {
        class_1959 newBiome = BiomeUtils.DEFAULT_BIOME;
        if (GameUtils.isInGame()) {
            newBiome = GameUtils.getPlayer().method_5770().method_23753(GameUtils.getPlayer().method_24515());
        }
        this.setBiome(newBiome);
    }

    public void setBiome(class_1959 biome) {
        if (this.biome != biome) {
            this.biome = biome;
            this.info = BiomeLibrary.getBiomeInfo(this.biome);
            this.name.reset();
            this.modid.reset();
            this.id.reset();
            this.category.reset();
            this.precipitationType.reset();
            this.traits.reset();
        }
    }

    @Override
    public String getModId() {
        return this.modid.get();
    }

    @Override
    public String getId() {
        return this.id.get();
    }

    @Override
    public String getName() {
        return this.name.get();
    }

    @Override
    public float getRainfall() {
        return this.biome.method_8715();
    }

    @Override
    public float getTemperature() {
        return this.biome.method_8712();
    }

    @Override
    public String getCategory() {
        return this.category.get();
    }

    @Override
    public String getPrecipitationType() {
        return this.precipitationType.get();
    }

    @Override
    public String getTraits() {
        return this.traits.get().toString();
    }

    @Override
    public boolean is(String trait) {
        return this.traits.get().contains(trait);
    }

    @Override
    public boolean isAllOf(String ... trait) {
        if (trait == null || trait.length == 0) {
            return false;
        }
        BiomeTraits traits = this.traits.get();
        for (String t : trait) {
            if (traits.contains(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isOneOf(String ... trait) {
        if (trait == null || trait.length == 0) {
            return false;
        }
        BiomeTraits traits = this.traits.get();
        for (String t : trait) {
            if (!traits.contains(t)) continue;
            return true;
        }
        return false;
    }
}

