/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.diagnostics;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2960;
import net.minecraft.class_4235;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.math.TimerEMA;
import org.orecruncher.dsurround.mixins.core.MixinSoundManagerAccessor;
import org.orecruncher.dsurround.mixins.core.MixinSoundSystemAccessors;

@Environment(value=EnvType.CLIENT)
public final class SoundEngineDiagnostics {
    private static final String FMT_DBG_SOUND = class_124.field_1065 + "%s: %d";

    public static void register() {
        ClientEventHooks.COLLECT_DIAGNOSTICS.register(SoundEngineDiagnostics::onCollect);
    }

    private static void onCollect(Collection<String> left, Collection<String> right, Collection<TimerEMA> timers) {
        left.add("");
        MixinSoundManagerAccessor manager = (MixinSoundManagerAccessor)GameUtils.getSoundHander();
        MixinSoundSystemAccessors accessors = (MixinSoundSystemAccessors)manager.getSoundSystem();
        Map<class_1113, class_4235.class_4236> sources = accessors.getSources();
        left.add(class_124.field_1065 + GameUtils.getSoundHander().method_20305());
        if (sources.size() > 0) {
            accessors.getSources().keySet().stream().map(s -> s.method_4776().method_4767()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().map(e -> String.format(FMT_DBG_SOUND, ((class_2960)e.getKey()).toString(), e.getValue())).sorted().forEach(left::add);
        } else {
            left.add(class_124.field_1065 + "  No sounds playing");
        }
    }
}

