/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.diagnostics;

import java.util.Collection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.lib.math.TimerEMA;

@Environment(value=EnvType.CLIENT)
public final class ClientProfiler {
    private static final TimerEMA clientTick = new TimerEMA("Client Tick");
    private static final TimerEMA lastTick = new TimerEMA("Last Tick");
    private static long lastTickMark = -1L;
    private static long timeMark = 0L;
    private static float tps = 0.0f;

    public static void register() {
        ClientTickEvents.START_CLIENT_TICK.register(ClientProfiler::tickStart);
        ClientTickEvents.END_CLIENT_TICK.register(ClientProfiler::tickEnd);
        ClientEventHooks.COLLECT_DIAGNOSTICS.register(ClientProfiler::onCollect);
    }

    private static void tickStart(class_310 client) {
        timeMark = System.nanoTime();
        if (lastTickMark != -1L) {
            lastTick.update(timeMark - lastTickMark);
            tps = class_3532.method_15363((float)((float)(50.0 / lastTick.getMSecs() * 20.0)), (float)0.0f, (float)20.0f);
        }
        lastTickMark = timeMark;
    }

    private static void tickEnd(class_310 client) {
        long delta = System.nanoTime() - timeMark;
        clientTick.update(delta);
    }

    private static void onCollect(Collection<String> left, Collection<String> right, Collection<TimerEMA> timers) {
        timers.add(clientTick);
        timers.add(lastTick);
        right.add(class_124.field_1076 + String.format("Client TPS:%7.3fms", Float.valueOf(tps)));
    }
}

