/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.diagnostics;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import org.orecruncher.dsurround.config.BlockLibrary;
import org.orecruncher.dsurround.config.block.BlockInfo;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.math.TimerEMA;

@Environment(value=EnvType.CLIENT)
public class BlockViewer {
    private static final String COLOR = class_124.field_1075.toString();
    private static final String COLOR_TITLE = COLOR + class_124.field_1073;

    public static void register() {
        ClientEventHooks.COLLECT_DIAGNOSTICS.register(BlockViewer::onCollect);
    }

    private static void processBlockHitResult(String type, class_1937 world, class_3965 result, Collection<String> data) {
        if (result.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        data.add("");
        data.add(COLOR_TITLE + type);
        class_2680 state = world.method_8320(result.method_17777());
        data.add(state.method_26204().toString());
        BlockInfo info = BlockLibrary.getBlockInfo(state);
        String wallOfText = info.toString();
        List lines = Arrays.stream(wallOfText.split("\n")).map(l -> l.replace("[", "").replace("]", "").strip()).filter(s -> !Strings.isNullOrEmpty((String)s)).collect(Collectors.toList());
        data.addAll(lines);
    }

    private static void onCollect(Collection<String> left, Collection<String> right, Collection<TimerEMA> timerEMAS) {
        class_1297 entity = GameUtils.getMC().method_1560();
        if (entity == null) {
            return;
        }
        class_3965 blockHit = (class_3965)entity.method_5745(20.0, 0.0f, false);
        class_3965 fluidHit = (class_3965)entity.method_5745(20.0, 0.0f, true);
        BlockViewer.processBlockHitResult("Block", entity.method_5770(), blockHit, right);
        if (!blockHit.method_17777().equals((Object)fluidHit.method_17777())) {
            BlockViewer.processBlockHitResult("Fluid", entity.method_5770(), fluidHit, right);
        }
    }
}

