/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.audio.effects;

import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openal.AL10;
import org.orecruncher.dsurround.Client;

public abstract class Slot {
    private final Supplier<Integer> factory;
    private int slot = 0;

    public Slot(Supplier<Integer> slotFactory) {
        this.factory = slotFactory;
    }

    public boolean isInitialized() {
        return this.slot != 0;
    }

    public final void initialize() {
        if (this.slot == 0) {
            this.execute(() -> {
                this.slot = this.factory.get();
            }, () -> "Slot factory get");
            this.execute(this::init0, () -> "Slot init0");
        }
    }

    public final void deinitialize() {
        this.slot = 0;
    }

    protected abstract void init0();

    public int getSlot() {
        return this.slot;
    }

    protected void execute(Runnable func) {
        this.execute(func, null);
    }

    protected void execute(Runnable func, @Nullable Supplier<String> context) {
        func.run();
        int error = AL10.alGetError();
        if (error != 0) {
            String errorName = AL10.alGetString((int)error);
            if (StringUtils.isEmpty((CharSequence)errorName)) {
                errorName = Integer.toString(error);
            }
            String msg = null;
            if (context != null) {
                msg = context.get();
            }
            if (msg == null) {
                msg = "NONE";
            }
            Client.LOGGER.warn(String.format("OpenAL Error: %s [%s]", errorName, msg), new Object[0]);
        }
    }
}

