/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.audio;

import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.config.BlockLibrary;
import org.orecruncher.dsurround.config.block.BlockInfo;
import org.orecruncher.dsurround.lib.math.MathStuff;
import org.orecruncher.dsurround.lib.math.ReusableRaycastContext;
import org.orecruncher.dsurround.lib.math.ReusableRaycastIterator;
import org.orecruncher.dsurround.lib.world.WorldUtils;
import org.orecruncher.dsurround.runtime.audio.SourceContext;
import org.orecruncher.dsurround.runtime.audio.WorldContext;
import org.orecruncher.dsurround.runtime.audio.effects.LowPassData;
import org.orecruncher.dsurround.runtime.audio.effects.SourcePropertyFloat;
import org.orecruncher.dsurround.sound.SoundInstanceHandler;

public final class SoundFXUtils {
    private static final int OCCLUSION_SEGMENTS = 5;
    private static final int REVERB_RAYS = Client.Config.enhancedSounds.reverbRays;
    private static final int REVERB_RAY_BOUNCES = Client.Config.enhancedSounds.reverbBounces;
    private static final float MAX_REVERB_DISTANCE = Client.Config.enhancedSounds.reverbRayTraceDistance;
    private static final float RECIP_TOTAL_RAYS = 1.0f / (float)(REVERB_RAYS * REVERB_RAY_BOUNCES);
    private static final float RECIP_PRIMARY_RAYS = 1.0f / (float)REVERB_RAYS;
    private static final float ENERGY_COEFF = 0.1875f * RECIP_TOTAL_RAYS;
    private static final float ENERGY_CONST = 0.0625f * RECIP_TOTAL_RAYS;
    private static final class_243[] REVERB_RAY_NORMALS = new class_243[REVERB_RAYS];
    private static final class_243[] REVERB_RAY_PROJECTED = new class_243[REVERB_RAYS];
    private static final class_243[] SURFACE_DIRECTION_NORMALS = new class_243[class_2350.values().length];
    private final SourceContext source;

    public SoundFXUtils(SourceContext source) {
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculate(WorldContext ctx) {
        assert (ctx.player != null);
        assert (ctx.world != null);
        assert (this.source.getSound() != null);
        if (ctx.isNotValid() || !this.source.isEnabled() || !SoundInstanceHandler.inRange(ctx.playerEyePosition, this.source.getSound()) || this.source.getPosition().equals((Object)class_243.field_1353)) {
            this.clearSettings();
            return;
        }
        class_243 soundPos = SoundFXUtils.offsetPositionIfSolid(ctx.world, this.source.getPosition(), ctx.playerEyePosition);
        float absorptionCoeff = 3.0f;
        float airAbsorptionFactor = SoundFXUtils.calculateWeatherAbsorption(ctx, soundPos, ctx.playerEyePosition);
        float occlusionAccumulation = this.calculateOcclusion(ctx, soundPos, ctx.playerEyePosition);
        float sendCoeff = -occlusionAccumulation * 3.0f;
        float directCutoff = (float)MathStuff.exp(sendCoeff);
        directCutoff *= 1.0f - ctx.auralDampening;
        float sendGain0 = 0.0f;
        float sendGain1 = 0.0f;
        float sendGain2 = 0.0f;
        float sendGain3 = 0.0f;
        float[] bounceRatio = new float[REVERB_RAY_BOUNCES];
        float sharedAirspace = 0.0f;
        ReusableRaycastContext traceContext = new ReusableRaycastContext(ctx.world, class_3959.class_3960.field_17558, class_3959.class_242.field_1345);
        block3: for (int i = 0; i < REVERB_RAYS; ++i) {
            class_243 origin = soundPos;
            class_243 target = origin.method_1019(REVERB_RAY_PROJECTED[i]);
            class_3965 rayHit = traceContext.trace(origin, target);
            if (SoundFXUtils.isMiss(rayHit)) continue;
            class_2338 lastHitBlock = rayHit.method_17777();
            class_243 lastHitPos = rayHit.method_17784();
            class_243 lastHitNormal = SoundFXUtils.surfaceNormal(rayHit.method_17780());
            class_243 lastRayDir = REVERB_RAY_NORMALS[i];
            double totalRayDistance = origin.method_1022(rayHit.method_17784());
            for (int j = 0; j < REVERB_RAY_BOUNCES; ++j) {
                float blockReflectivity = SoundFXUtils.getReflectivity(ctx.world.method_8320(lastHitBlock));
                float energyTowardsPlayer = blockReflectivity * ENERGY_COEFF + ENERGY_CONST;
                class_243 newRayDir = MathStuff.reflection(lastRayDir, lastHitNormal);
                origin = MathStuff.addScaled(lastHitPos, newRayDir, 0.01f);
                rayHit = traceContext.trace(origin, target = MathStuff.addScaled(origin, newRayDir, MAX_REVERB_DISTANCE));
                if (SoundFXUtils.isMiss(rayHit)) {
                    totalRayDistance += lastHitPos.method_1022(ctx.playerEyePosition);
                } else {
                    int n = j;
                    bounceRatio[n] = bounceRatio[n] + blockReflectivity;
                    totalRayDistance += lastHitPos.method_1022(rayHit.method_17784());
                    lastHitPos = rayHit.method_17784();
                    lastHitNormal = SoundFXUtils.surfaceNormal(rayHit.method_17780());
                    lastRayDir = newRayDir;
                    lastHitBlock = rayHit.method_17777();
                    class_243 finalRayStart = MathStuff.addScaled(lastHitPos, lastHitNormal, 0.01f);
                    class_3965 finalRayHit = traceContext.trace(finalRayStart, ctx.playerEyePosition);
                    if (SoundFXUtils.isMiss(finalRayHit)) {
                        sharedAirspace += 1.0f;
                    }
                }
                assert (totalRayDistance >= 0.0);
                float reflectionDelay = (float)totalRayDistance * 0.12f * blockReflectivity;
                float cross0 = 1.0f - MathStuff.clamp1(Math.abs(reflectionDelay - 0.0f));
                float cross1 = 1.0f - MathStuff.clamp1(Math.abs(reflectionDelay - 1.0f));
                float cross2 = 1.0f - MathStuff.clamp1(Math.abs(reflectionDelay - 2.0f));
                float cross3 = MathStuff.clamp1(reflectionDelay - 2.0f);
                sendGain0 += cross0 * energyTowardsPlayer * 6.4f;
                sendGain1 += cross1 * energyTowardsPlayer * 12.8f;
                sendGain2 += cross2 * energyTowardsPlayer * 12.8f;
                sendGain3 += cross3 * energyTowardsPlayer * 12.8f;
                if (SoundFXUtils.isMiss(rayHit)) continue block3;
            }
        }
        bounceRatio[0] = bounceRatio[0] / (float)REVERB_RAYS;
        bounceRatio[1] = bounceRatio[1] / (float)REVERB_RAYS;
        bounceRatio[2] = bounceRatio[2] / (float)REVERB_RAYS;
        bounceRatio[3] = bounceRatio[3] / (float)REVERB_RAYS;
        float sharedAirspaceWeight0 = MathStuff.clamp1((sharedAirspace *= RECIP_TOTAL_RAYS * 64.0f) / 20.0f);
        float sharedAirspaceWeight1 = MathStuff.clamp1(sharedAirspace / 15.0f);
        float sharedAirspaceWeight2 = MathStuff.clamp1(sharedAirspace / 10.0f);
        float sharedAirspaceWeight3 = MathStuff.clamp1(sharedAirspace / 10.0f);
        float exp1 = (float)MathStuff.exp(sendCoeff);
        float exp2 = (float)MathStuff.exp(sendCoeff * 1.5f);
        float sendCutoff0 = exp1 * (1.0f - sharedAirspaceWeight0) + sharedAirspaceWeight0;
        float sendCutoff1 = exp1 * (1.0f - sharedAirspaceWeight1) + sharedAirspaceWeight1;
        float sendCutoff2 = exp2 * (1.0f - sharedAirspaceWeight2) + sharedAirspaceWeight2;
        float sendCutoff3 = exp2 * (1.0f - sharedAirspaceWeight3) + sharedAirspaceWeight3;
        float averageSharedAirspace = (sharedAirspaceWeight0 + sharedAirspaceWeight1 + sharedAirspaceWeight2 + sharedAirspaceWeight3) * 0.25f;
        directCutoff = Math.max((float)Math.sqrt(averageSharedAirspace) * 0.2f, directCutoff);
        float directGain = (float)MathStuff.pow(directCutoff, 0.1);
        sendGain1 *= bounceRatio[1];
        sendGain2 *= (float)MathStuff.pow(bounceRatio[2], 3.0);
        sendGain3 *= (float)MathStuff.pow(bounceRatio[3], 4.0);
        sendGain0 = MathStuff.clamp1(sendGain0);
        sendGain1 = MathStuff.clamp1(sendGain1);
        sendGain2 = MathStuff.clamp1(sendGain2 * 1.05f - 0.05f);
        sendGain3 = MathStuff.clamp1(sendGain3 * 1.05f - 0.05f);
        sendGain0 *= (float)MathStuff.pow(sendCutoff0, 0.1);
        sendGain1 *= (float)MathStuff.pow(sendCutoff1, 0.1);
        sendGain2 *= (float)MathStuff.pow(sendCutoff2, 0.1);
        sendGain3 *= (float)MathStuff.pow(sendCutoff3, 0.1);
        if (ctx.player.method_5869()) {
            sendCutoff0 *= 0.4f;
            sendCutoff1 *= 0.4f;
            sendCutoff2 *= 0.4f;
            sendCutoff3 *= 0.4f;
        }
        LowPassData lp0 = this.source.getLowPass0();
        LowPassData lp1 = this.source.getLowPass1();
        LowPassData lp2 = this.source.getLowPass2();
        LowPassData lp3 = this.source.getLowPass3();
        LowPassData direct = this.source.getDirect();
        SourcePropertyFloat prop = this.source.getAirAbsorb();
        Object object = this.source.sync();
        synchronized (object) {
            lp0.gain = sendGain0;
            lp0.gainHF = sendCutoff0;
            lp0.setProcess(true);
            lp1.gain = sendGain1;
            lp1.gainHF = sendCutoff1;
            lp1.setProcess(true);
            lp2.gain = sendGain2;
            lp2.gainHF = sendCutoff2;
            lp2.setProcess(true);
            lp3.gain = sendGain3;
            lp3.gainHF = sendCutoff3;
            lp3.setProcess(true);
            direct.gain = directGain;
            direct.gainHF = directCutoff;
            direct.setProcess(true);
            prop.setValue(airAbsorptionFactor);
            prop.setProcess(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSettings() {
        Object object = this.source.sync();
        synchronized (object) {
            this.source.getLowPass0().setProcess(false);
            this.source.getLowPass1().setProcess(false);
            this.source.getLowPass2().setProcess(false);
            this.source.getLowPass3().setProcess(false);
            this.source.getDirect().setProcess(false);
            this.source.getAirAbsorb().setProcess(false);
        }
    }

    private float calculateOcclusion(WorldContext ctx, class_243 origin, class_243 target) {
        if (SoundFXUtils.skipOcclusion(this.source.getCategory())) {
            return 0.0f;
        }
        assert (ctx.world != null);
        assert (ctx.player != null);
        float factor = 0.0f;
        class_243 lastHit = origin;
        class_2680 lastState = ctx.world.method_8320(new class_2338(lastHit.method_10216(), lastHit.method_10214(), lastHit.method_10215()));
        ReusableRaycastContext traceContext = new ReusableRaycastContext(ctx.world, origin, target, class_3959.class_3960.field_23142, class_3959.class_242.field_1345);
        ReusableRaycastIterator itr = new ReusableRaycastIterator(traceContext);
        for (int i = 0; i < 5 && itr.hasNext(); ++i) {
            class_3965 result = itr.next();
            float occlusion = SoundFXUtils.getOcclusion(lastState);
            double distance = lastHit.method_1022(result.method_17784());
            factor = (float)((double)factor + (double)occlusion * distance);
            lastHit = result.method_17784();
            lastState = ctx.world.method_8320(result.method_17777());
        }
        return factor;
    }

    private static float calculateWeatherAbsorption(WorldContext ctx, class_243 pt1, class_243 pt2) {
        assert (ctx.world != null);
        if (!ctx.isPrecipitating) {
            return 1.0f;
        }
        class_2338 low = new class_2338(pt1);
        class_2338 mid = new class_2338(MathStuff.addScaled(pt1, pt2, 0.5));
        class_2338 high = new class_2338(pt2);
        class_1959.class_1963 rt1 = WorldUtils.getCurrentPrecipitationAt(ctx.world, low);
        class_1959.class_1963 rt2 = WorldUtils.getCurrentPrecipitationAt(ctx.world, mid);
        class_1959.class_1963 rt3 = WorldUtils.getCurrentPrecipitationAt(ctx.world, high);
        float factor = SoundFXUtils.calcFactor(rt1, 0.25f);
        factor += SoundFXUtils.calcFactor(rt2, 0.5f);
        factor += SoundFXUtils.calcFactor(rt3, 0.25f);
        return factor *= ctx.precipitationStrength;
    }

    private static float getReflectivity(class_2680 state) {
        BlockInfo info = BlockLibrary.getBlockInfo(state);
        return info.getSoundReflectivity();
    }

    private static float getOcclusion(class_2680 state) {
        BlockInfo info = BlockLibrary.getBlockInfo(state);
        return info.getSoundOcclusion();
    }

    private static class_243 surfaceNormal(class_2350 d) {
        return SURFACE_DIRECTION_NORMALS[d.ordinal()];
    }

    private static class_243 offsetPositionIfSolid(class_1937 world, class_243 origin, class_243 target) {
        if (world.method_8320(new class_2338(origin)) != class_2246.field_10124.method_9564()) {
            class_243 normal = origin.method_1035(target).method_1029();
            return MathStuff.addScaled(origin, normal, 0.876f);
        }
        return origin;
    }

    private static float calcFactor(class_1959.class_1963 type, float base) {
        return type == class_1959.class_1963.field_9384 ? base : base * (type == class_1959.class_1963.field_9383 ? 5.0f : 2.0f);
    }

    private static boolean isMiss(@Nullable class_3965 result) {
        return result == null || result.method_17783() == class_239.class_240.field_1333;
    }

    private static boolean skipOcclusion(class_3419 category) {
        return !Client.Config.enhancedSounds.enableOcclusionProcessing || category == class_3419.field_15250 || category == class_3419.field_15253;
    }

    static {
        for (class_2350 d : class_2350.values()) {
            SoundFXUtils.SURFACE_DIRECTION_NORMALS[d.ordinal()] = class_243.method_24954((class_2382)d.method_10163());
        }
        for (int i = 0; i < REVERB_RAYS; ++i) {
            double longitude = MathStuff.ANGLE * (double)i;
            double latitude = Math.asin((double)i / (double)REVERB_RAYS * 2.0 - 1.0);
            SoundFXUtils.REVERB_RAY_NORMALS[i] = new class_243(Math.cos(latitude) * Math.cos(longitude), Math.cos(latitude) * Math.sin(longitude), Math.sin(latitude)).method_1029();
            SoundFXUtils.REVERB_RAY_PROJECTED[i] = REVERB_RAY_NORMALS[i].method_1021((double)MAX_REVERB_DISTANCE);
        }
    }
}

