/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.audio;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_4224;
import net.minecraft.class_4231;
import net.minecraft.class_4235;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openal.AL10;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.lib.Singleton;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.math.TimerEMA;
import org.orecruncher.dsurround.lib.threading.Worker;
import org.orecruncher.dsurround.runtime.audio.AudioUtilities;
import org.orecruncher.dsurround.runtime.audio.Conversion;
import org.orecruncher.dsurround.runtime.audio.SourceContext;
import org.orecruncher.dsurround.runtime.audio.WorldContext;
import org.orecruncher.dsurround.runtime.audio.effects.Effects;
import org.orecruncher.dsurround.xface.ISourceContext;

public final class SoundFXProcessor {
    private static final IModLog LOGGER = Client.LOGGER.createChild(SoundFXProcessor.class);
    private static final int SOUND_PROCESS_ITERATION = 50;
    static boolean isAvailable;
    private static SourceContext[] sources;
    private static Worker soundProcessor;
    private static final Singleton<ExecutorService> threadPool;
    private static WorldContext worldContext;

    public static WorldContext getWorldContext() {
        return worldContext;
    }

    public static boolean isAvailable() {
        return isAvailable;
    }

    public static void initialize() {
        Effects.initialize();
        sources = new SourceContext[AudioUtilities.getMaxSounds()];
        if (soundProcessor == null) {
            soundProcessor = new Worker("Enhanced Sound Processor", SoundFXProcessor::processSounds, 50, LOGGER);
            soundProcessor.start();
        }
        isAvailable = true;
    }

    public static void deinitialize() {
        if (SoundFXProcessor.isAvailable()) {
            isAvailable = false;
            if (soundProcessor != null) {
                soundProcessor.stop();
                soundProcessor = null;
            }
            if (sources != null) {
                Arrays.fill(sources, null);
                sources = null;
            }
            Effects.deinitialize();
        }
    }

    private static boolean shouldIgnoreSound(class_1113 sound) {
        return sound.method_4787() || sound.method_4777() == class_1113.class_1114.field_5478 || sound.method_4774() == class_3419.field_15250 || sound.method_4774() == class_3419.field_15253 || sound.method_4774() == class_3419.field_15252;
    }

    public static void onSoundPlay(class_1113 sound, class_4235.class_4236 entry) {
        if (!SoundFXProcessor.isAvailable()) {
            return;
        }
        if (SoundFXProcessor.shouldIgnoreSound(sound)) {
            return;
        }
        entry.method_19735(source -> {
            int id = ((ISourceContext)source).getId();
            if (id > 0) {
                SourceContext ctx = new SourceContext();
                ctx.attachSound(sound);
                ctx.enable();
                ctx.exec();
                ((ISourceContext)source).setData(ctx);
                SoundFXProcessor.sources[id - 1] = ctx;
            }
        });
    }

    public static void tick(class_4224 source) {
        Optional<SourceContext> ctx = ((ISourceContext)source).getData();
        ctx.ifPresent(sourceContext -> sourceContext.tick(((ISourceContext)source).getId()));
    }

    public static void stopSoundPlay(class_4224 source) {
        Optional<SourceContext> ctx = ((ISourceContext)source).getData();
        if (ctx.isPresent()) {
            SoundFXProcessor.sources[((ISourceContext)source).getId() - 1] = null;
        }
    }

    public static void doMonoConversion(class_4224 source, class_4231 buffer) {
        if (!Client.Config.enhancedSounds.enableMonoConversion) {
            return;
        }
        Optional<SourceContext> ctx = ((ISourceContext)source).getData();
        if (ctx.isEmpty()) {
            Conversion.convert(buffer);
        } else {
            class_1113 s = ctx.get().getSound();
            if (s != null && s.method_4777() != class_1113.class_1114.field_5478 && !s.method_4787()) {
                Conversion.convert(buffer);
            }
        }
    }

    public static void clientTick(class_310 client) {
        if (SoundFXProcessor.isAvailable()) {
            worldContext = new WorldContext();
        }
    }

    private static void processSounds() {
        try {
            int i;
            ExecutorService pool = threadPool.get();
            assert (pool != null);
            ObjectArray<Future<Void>> tasks = new ObjectArray<Future<Void>>(sources.length);
            for (i = 0; i < sources.length; ++i) {
                SourceContext ctx = sources[i];
                if (ctx == null || !ctx.shouldExecute()) continue;
                tasks.add(pool.submit(ctx));
            }
            for (i = 0; i < tasks.size(); ++i) {
                try {
                    ((Future)tasks.get(i)).get();
                    continue;
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            }
        }
        catch (Throwable t) {
            LOGGER.error(t, "Error in SoundContext ForkJoinPool", new Object[0]);
        }
    }

    private static void onGatherText(Collection<String> left, Collection<String> right, Collection<TimerEMA> timerEMAS) {
        String msg;
        if (SoundFXProcessor.isAvailable() && soundProcessor != null && !StringUtils.isEmpty((CharSequence)(msg = soundProcessor.getDiagnosticString()))) {
            left.add(class_124.field_1060 + msg);
        }
    }

    public static void validate(String msg) {
        SoundFXProcessor.validate(() -> msg);
    }

    public static void validate(@Nullable Supplier<String> err) {
        int error = AL10.alGetError();
        if (error != 0) {
            String errorName = AL10.alGetString((int)error);
            if (StringUtils.isEmpty((CharSequence)errorName)) {
                errorName = Integer.toString(error);
            }
            String msg = null;
            if (err != null) {
                msg = err.get();
            }
            if (msg == null) {
                msg = "NONE";
            }
            throw new IllegalStateException(String.format("OpenAL Error: %s [%s]", errorName, msg));
        }
    }

    static {
        threadPool = new Singleton<ExecutorService>(() -> {
            int threads = Client.Config.enhancedSounds.backgroundThreadWorkers;
            if (threads == 0) {
                threads = 2;
            }
            LOGGER.info("Threads allocated to enhanced sound processor: %d", threads);
            return Executors.newFixedThreadPool(threads);
        });
        worldContext = new WorldContext();
        ClientEventHooks.COLLECT_DIAGNOSTICS.register(SoundFXProcessor::onGatherText);
        ClientTickEvents.START_CLIENT_TICK.register(SoundFXProcessor::clientTick);
    }
}

