/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime.audio;

import net.minecraft.class_1113;
import net.minecraft.class_1140;
import net.minecraft.class_4225;
import net.minecraft.class_4227;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALC11;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.SOFTHRTF;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.audio.AlAttributeBuilder;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.mixins.audio.MixinSoundEngineAccessor;
import org.orecruncher.dsurround.mixins.core.MixinAbstractSoundInstance;
import org.orecruncher.dsurround.mixins.core.MixinSoundManagerAccessor;
import org.orecruncher.dsurround.mixins.core.MixinSoundSystemAccessors;
import org.orecruncher.dsurround.runtime.audio.SoundFXProcessor;

public final class AudioUtilities {
    private static final IModLog LOGGER = Client.LOGGER.createChild(AudioUtilities.class);
    private static final String[] HRTF_STATUS = new String[]{"ALC_HRTF_DISABLED_SOFT", "ALC_HRTF_ENABLED_SOFT", "ALC_HRTF_DENIED_SOFT", "ALC_HRTF_REQUIRED_SOFT", "ALC_HRTF_HEADPHONES_DETECTED_SOFT", "ALC_HRTF_UNSUPPORTED_FORMAT_SOFT"};
    private static int MAX_SOUNDS = 0;
    private static final ThreadLocal<StringBuilder> builder = ThreadLocal.withInitial(() -> new StringBuilder(128));

    public static int getMaxSounds() {
        return MAX_SOUNDS;
    }

    public static class_1140 getSoundSystem() {
        MixinSoundManagerAccessor manager = (MixinSoundManagerAccessor)GameUtils.getSoundHander();
        return manager.getSoundSystem();
    }

    public static class_4227 getSoundListener() {
        return ((MixinSoundSystemAccessors)AudioUtilities.getSoundSystem()).getListener();
    }

    public static String debugString(class_1113 sound) {
        try {
            StringBuilder sb = builder.get();
            sb.setLength(0);
            MixinAbstractSoundInstance accessor = (MixinAbstractSoundInstance)sound;
            sb.append(sound.getClass().getSimpleName()).append("{");
            sb.append(sound.method_4775());
            sb.append(", ").append(sound.method_4774().method_14840());
            sb.append(", ").append(sound.method_4777().toString());
            sb.append(String.format(", (%.2f,%.2f,%.2f)", sound.method_4784(), sound.method_4779(), sound.method_4778()));
            if (sound.method_4776() != null) {
                sb.append(String.format(", v: %.4f(%.4f)", Float.valueOf(sound.method_4781()), Float.valueOf(accessor.getRawVolume())));
                sb.append(String.format(", p: %.4f(%.4f)", Float.valueOf(sound.method_4782()), Float.valueOf(accessor.getRawPitch())));
                sb.append(", s: ").append(sound.method_4776().method_4769());
            } else {
                sb.append(String.format(", vr: %.4f", Float.valueOf(accessor.getRawVolume())));
                sb.append(String.format(", pr: %.4f", Float.valueOf(accessor.getRawPitch())));
            }
            sb.append(", g: ").append(sound.method_4787());
            sb.append("}");
            if (!sound.method_4787()) {
                class_4227 listener = AudioUtilities.getSoundListener();
                double distance = Math.sqrt(listener.method_27268().method_1028(sound.method_4784(), sound.method_4779(), sound.method_4778()));
                sb.append(String.format(", distance: %.1f", distance));
                if (sound.method_4776() != null) {
                    sb.append(" (").append(sound.method_4776().method_4770()).append(")");
                }
            }
            return sb.toString();
        }
        catch (Throwable throwable) {
            return "Unable to format sound!";
        }
    }

    public static void initialize(class_4225 soundEngine) {
        MixinSoundEngineAccessor accessor = (MixinSoundEngineAccessor)soundEngine;
        try {
            long device = accessor.getDevicePointer();
            boolean hasFX = false;
            if (AudioUtilities.doEnhancedSounds()) {
                LOGGER.info("Enhanced sounds are enabled.  Will perform sound engine reconfiguration.", new Object[0]);
                ALCCapabilities deviceCaps = ALC.createCapabilities((long)device);
                hasFX = deviceCaps.ALC_EXT_EFX;
                if (!hasFX) {
                    LOGGER.warn("EFX audio extensions not available for the current sound device!", new Object[0]);
                } else {
                    AlAttributeBuilder builder = new AlAttributeBuilder().add(131075, 4);
                    int freq = Client.Config.enhancedSounds.outputFrequency;
                    if (freq != 0) {
                        Client.LOGGER.info("Attempting to set output frequency of %d", freq);
                        builder.add(4103, freq);
                    }
                    int[] attributes = builder.build();
                    long ctx = ALC10.alcCreateContext((long)device, (int[])attributes);
                    ALC10.alcMakeContextCurrent((long)ctx);
                    accessor.setContextPointer(ctx);
                    AL10.alEnable((int)512);
                    if (deviceCaps.ALC_SOFT_HRTF) {
                        int status = ALC10.alcGetInteger((long)device, (int)6547);
                        LOGGER.info("HRTF status report before configuration: %s", HRTF_STATUS[status]);
                        if (status == 0 && Client.Config.enhancedSounds.enableHRTF) {
                            boolean result = SOFTHRTF.alcResetDeviceSOFT((long)device, (int[])new int[]{6546, 1, 0});
                            if (result) {
                                status = ALC10.alcGetInteger((long)device, (int)6547);
                                LOGGER.warn("After configuration OpenAL reports HRTF status %s", HRTF_STATUS[status]);
                            } else {
                                LOGGER.warn("Unable to set HRTF feature in OpenAL", new Object[0]);
                            }
                        } else {
                            LOGGER.info("HRTF is already configured or Dynamic Surroundings is not configured to enable", new Object[0]);
                        }
                    }
                }
            }
            MAX_SOUNDS = ALC11.alcGetInteger((long)device, (int)4112);
            if (hasFX) {
                SoundFXProcessor.initialize();
            }
            String vendor = AL10.alGetString((int)45057);
            String version = AL10.alGetString((int)45058);
            String renderer = AL10.alGetString((int)45059);
            String extensions = AL10.alGetString((int)45060);
            int frequency = ALC11.alcGetInteger((long)device, (int)4103);
            LOGGER.info("Vendor: %s", vendor);
            LOGGER.info("Version: %s", version);
            LOGGER.info("Renderer: %s", renderer);
            LOGGER.info("Extensions: %s", extensions);
            LOGGER.info("Frequency: %d", frequency);
        }
        catch (Throwable t) {
            LOGGER.warn(t.getMessage(), new Object[0]);
            LOGGER.warn("OpenAL special effects for sounds will not be available", new Object[0]);
        }
    }

    private static boolean doEnhancedSounds() {
        if (!Client.Config.enhancedSounds.enableEnhancedSounds) {
            LOGGER.warn("Enhanced sounds are not enabled.  No fancy sounds for you!", new Object[0]);
            return false;
        }
        return true;
    }

    public static void deinitialize(class_4225 soundEngine) {
        SoundFXProcessor.deinitialize();
    }

    public static void onPlaySound(class_1113 sound) {
        LOGGER.debug(2, () -> "PLAYING: " + AudioUtilities.debugString(sound));
    }
}

