/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.runtime;

import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.scripting.ExecutionContext;
import org.orecruncher.dsurround.lib.scripting.Script;
import org.orecruncher.dsurround.runtime.sets.BiomeVariables;
import org.orecruncher.dsurround.runtime.sets.DimensionVariables;
import org.orecruncher.dsurround.runtime.sets.DiurnalVariables;
import org.orecruncher.dsurround.runtime.sets.EnvironmentState;
import org.orecruncher.dsurround.runtime.sets.PlayerVariables;
import org.orecruncher.dsurround.runtime.sets.WeatherVariables;

@Environment(value=EnvType.CLIENT)
public final class ConditionEvaluator {
    public static ConditionEvaluator INSTANCE = new ConditionEvaluator();
    final BiomeVariables biomeVariables;
    final DimensionVariables dimensionVariables;
    final DiurnalVariables diurnalVariables;
    final PlayerVariables playerVariables;
    final WeatherVariables weatherVariables;
    final EnvironmentState environmentState;
    private final ExecutionContext context = new ExecutionContext("Conditions");

    public ConditionEvaluator() {
        this.biomeVariables = new BiomeVariables();
        this.context.add(this.biomeVariables);
        this.dimensionVariables = new DimensionVariables();
        this.context.add(this.dimensionVariables);
        this.diurnalVariables = new DiurnalVariables();
        this.context.add(this.diurnalVariables);
        this.playerVariables = new PlayerVariables();
        this.context.add(this.playerVariables);
        this.weatherVariables = new WeatherVariables();
        this.context.add(this.weatherVariables);
        this.environmentState = new EnvironmentState();
        this.context.add(this.environmentState);
    }

    public void tick() {
        this.context.update();
    }

    public boolean check(Script conditions) {
        Object result = this.eval(conditions);
        return result instanceof Boolean && (Boolean)result != false;
    }

    public Object eval(Script conditions) {
        Optional<Object> result = this.context.eval(conditions);
        return result.orElse(false);
    }

    static {
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (GameUtils.isInGame() && !client.method_1493()) {
                INSTANCE.tick();
            }
        });
    }
}

