/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.scanner;

import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.orecruncher.dsurround.config.BlockLibrary;
import org.orecruncher.dsurround.config.block.BlockInfo;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.effects.IBlockEffectProducer;
import org.orecruncher.dsurround.lib.scanner.RandomScanner;
import org.orecruncher.dsurround.lib.scanner.ScanContext;
import org.orecruncher.dsurround.processing.misc.BlockEffectManager;
import org.orecruncher.dsurround.sound.ISoundFactory;
import org.orecruncher.dsurround.sound.MinecraftAudioPlayer;

@Environment(value=EnvType.CLIENT)
public class RandomBlockEffectScanner
extends RandomScanner {
    public static final int NEAR_RANGE = 16;
    public static final int FAR_RANGE = 32;
    private static final int ITERATION_COUNT = 667;
    private final BlockEffectManager effectManager;

    public RandomBlockEffectScanner(ScanContext locus, BlockEffectManager manager, int range) {
        super(locus, "RandomBlockScanner: " + range, range, 667);
        this.effectManager = manager;
    }

    @Override
    protected boolean interestingBlock(class_2680 state) {
        return BlockLibrary.getBlockInfo(state).hasSoundsOrEffects();
    }

    @Override
    public void blockScan(class_2680 state, class_2338 pos, Random rand) {
        ISoundFactory sound;
        BlockInfo info = BlockLibrary.getBlockInfo(state);
        Collection<IBlockEffectProducer> effects = info.getEffectProducers();
        if (effects.size() > 0 && this.effectManager.okToSpawn(pos)) {
            class_1937 world = this.locus.getWorld();
            for (IBlockEffectProducer be : effects) {
                Optional<IBlockEffect> effect = be.produce(world, state, pos, rand);
                if (!effect.isPresent()) continue;
                this.effectManager.add(effect.get());
                break;
            }
        }
        if ((sound = info.getSoundToPlay(rand)) != null) {
            class_1109 instance = sound.createAtLocation(pos);
            MinecraftAudioPlayer.INSTANCE.play((class_1113)instance);
        }
    }
}

