/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.scanner;

import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_4543;
import org.orecruncher.dsurround.config.BiomeLibrary;
import org.orecruncher.dsurround.config.DimensionLibrary;
import org.orecruncher.dsurround.config.InternalBiomes;
import org.orecruncher.dsurround.config.biome.BiomeInfo;
import org.orecruncher.dsurround.config.dimension.DimensionInfo;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.processing.Scanners;

@Environment(value=EnvType.CLIENT)
public final class BiomeScanner {
    public static final int SCAN_INTERVAL = 4;
    private static final int UNDERGROUND_THRESHOLD_OFFSET = 4;
    private static final int SURVEY_HORIZONTAL_DIMENSION = 18;
    private static final int SURVEY_HORIZONTAL_OFFSET = 8;
    private static final int SURVEY_VERTICAL_DIMENSION = 16;
    private static final int SURVEY_VERTICAL_OFFSET = 3;
    private static final int MAX_SURVEY_VOLUME = 5184;
    private static DimensionInfo surveyedDimension;
    private static boolean isUnderWater;
    private static BiomeInfo logicalBiomeInfo;
    private final class_2338.class_2339 mutable = new class_2338.class_2339();
    private int biomeArea;
    private Reference2IntOpenHashMap<BiomeInfo> weights = new Reference2IntOpenHashMap(8);
    private class_1959 surveyedBiome = null;
    private class_2338 surveyedPosition = class_2338.field_10980;

    public static BiomeInfo playerLogicBiomeInfo() {
        return logicalBiomeInfo;
    }

    public static DimensionInfo getDimInfo() {
        return surveyedDimension;
    }

    public static boolean isUnderWater() {
        return isUnderWater;
    }

    public void tick(long tickCount) {
        if (tickCount % 4L != 0L) {
            return;
        }
        class_1657 player = GameUtils.getPlayer();
        assert (player != null);
        class_1937 world = player.method_5770();
        class_2338 position = player.method_24515();
        DimensionInfo dimensionInfo = DimensionLibrary.getData(world);
        class_4543 biomes = world.method_22385();
        class_1959 playerBiome = biomes.method_22393(position);
        if (this.surveyedBiome != playerBiome || !surveyedDimension.equals(dimensionInfo) || !this.surveyedPosition.equals((Object)position)) {
            this.surveyedBiome = playerBiome;
            this.surveyedPosition = position;
            surveyedDimension = dimensionInfo;
            isUnderWater = player.method_5777((class_3494)class_3486.field_15517);
            if (isUnderWater) {
                BiomeInfo playerBiomeInfo = BiomeLibrary.getBiomeInfo(playerBiome);
                InternalBiomes internalBiome = playerBiomeInfo.isRiver() ? InternalBiomes.UNDER_RIVER : (playerBiomeInfo.isDeepOcean() ? InternalBiomes.UNDER_DEEP_OCEAN : (playerBiomeInfo.isOcean() ? InternalBiomes.UNDER_OCEAN : InternalBiomes.UNDER_WATER));
                logicalBiomeInfo = BiomeLibrary.getBiomeInfo(internalBiome);
                this.biomeArea = 1;
                this.weights.addTo((Object)logicalBiomeInfo, 1);
                return;
            }
            logicalBiomeInfo = this.resolveBiome(dimensionInfo, biomes, position);
            this.weights = new Reference2IntOpenHashMap(8);
            for (int z = 0; z < 18; ++z) {
                int dZ = z - 8 + this.surveyedPosition.method_10260();
                this.mutable.method_33099(dZ);
                for (int x = 0; x < 18; ++x) {
                    int dX = x - 8 + this.surveyedPosition.method_10263();
                    this.mutable.method_33097(dX);
                    for (int y = 0; y < 16; ++y) {
                        int dY = y - 3 + this.surveyedPosition.method_10264();
                        this.mutable.method_33098(dY);
                        BiomeInfo info = this.resolveBiome(dimensionInfo, biomes, (class_2338)this.mutable);
                        this.weights.addTo((Object)info, 1);
                    }
                }
            }
            this.biomeArea = 5184;
        }
    }

    private BiomeInfo resolveBiome(DimensionInfo dimInfo, class_4543 access, class_2338 pos) {
        class_1959 biome = access.method_22393(pos);
        if (biome.method_8688() != class_1959.class_1961.field_29217) {
            int y = pos.method_10264();
            if (y < dimInfo.getSeaLevel() - 4) {
                return BiomeLibrary.getBiomeInfo(InternalBiomes.UNDERGROUND);
            }
            if (Scanners.isInside()) {
                return BiomeLibrary.getBiomeInfo(InternalBiomes.INSIDE);
            }
            if (y >= dimInfo.getSpaceHeight()) {
                return BiomeLibrary.getBiomeInfo(InternalBiomes.SPACE);
            }
            if (y >= dimInfo.getCloudHeight()) {
                return BiomeLibrary.getBiomeInfo(InternalBiomes.CLOUDS);
            }
        }
        return BiomeLibrary.getBiomeInfo(biome);
    }

    public int getBiomeArea() {
        return this.biomeArea;
    }

    public Reference2IntOpenHashMap<BiomeInfo> getBiomes() {
        return this.weights;
    }
}

