/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.scanner;

import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.orecruncher.dsurround.config.BlockLibrary;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.effects.IBlockEffectProducer;
import org.orecruncher.dsurround.lib.scanner.CuboidScanner;
import org.orecruncher.dsurround.lib.scanner.ScanContext;
import org.orecruncher.dsurround.processing.misc.BlockEffectManager;

@Environment(value=EnvType.CLIENT)
public class AlwaysOnBlockEffectScanner
extends CuboidScanner {
    private final BlockEffectManager effectManager;

    public AlwaysOnBlockEffectScanner(ScanContext locus, BlockEffectManager manager, int range) {
        super(locus, "AlwaysOnBlockEffectScanner", range, 0);
        this.effectManager = manager;
    }

    @Override
    protected boolean interestingBlock(class_2680 state) {
        return BlockLibrary.getBlockInfo(state).hasAlwaysOnEffects();
    }

    @Override
    public void blockScan(class_2680 state, class_2338 pos, Random rand) {
        Collection<IBlockEffectProducer> effects = BlockLibrary.getBlockInfo(state).getAlwaysOnEffectProducers();
        if (effects.size() > 0 && this.effectManager.okToSpawn(pos)) {
            class_1937 world = this.locus.getWorld();
            for (IBlockEffectProducer be : effects) {
                Optional<IBlockEffect> effect = be.produce(world, state, pos, rand);
                if (!effect.isPresent()) continue;
                this.effectManager.add(effect.get());
                break;
            }
        }
    }
}

