/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing.misc;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.lib.BlockPosUtil;

@Environment(value=EnvType.CLIENT)
public class BlockEffectManager {
    private static final Predicate<IBlockEffect> STANDARD = system -> {
        system.tick();
        return system.isDone();
    };
    private final Long2ObjectOpenHashMap<IBlockEffect> systems = new Long2ObjectOpenHashMap(512);
    private class_2338 lastPos = class_2338.field_10980;

    public void tick(class_1657 player) {
        class_2338 current = player.method_24515();
        boolean sittingStill = this.lastPos.equals((Object)current);
        this.lastPos = current;
        Predicate<IBlockEffect> pred = STANDARD;
        if (!sittingStill) {
            double range = Client.Config.blockEffects.blockEffectRange;
            class_2338 min = new class_2338((double)current.method_10263() - range, (double)current.method_10264() - range, (double)current.method_10260() - range);
            class_2338 max = new class_2338((double)current.method_10263() + range, (double)current.method_10264() + range, (double)current.method_10260() + range);
            pred = system -> {
                if (BlockPosUtil.notContains(system.getPos(), min, max)) {
                    system.setDone();
                } else {
                    system.tick();
                }
                return system.isDone();
            };
        }
        this.systems.values().removeIf(pred);
    }

    public boolean okToSpawn(class_2338 pos) {
        return !this.systems.containsKey(pos.method_10063());
    }

    public void add(IBlockEffect system) {
        this.systems.put(system.getPos().method_10063(), (Object)system);
    }

    public int count() {
        return this.systems.size();
    }
}

