/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Collection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import org.orecruncher.dsurround.config.biome.BiomeInfo;
import org.orecruncher.dsurround.lib.TickCounter;
import org.orecruncher.dsurround.lib.math.TimerEMA;
import org.orecruncher.dsurround.processing.ClientHandler;
import org.orecruncher.dsurround.processing.scanner.BiomeScanner;
import org.orecruncher.dsurround.processing.scanner.CeilingScanner;
import org.orecruncher.dsurround.processing.scanner.VillageScanner;

@Environment(value=EnvType.CLIENT)
public class Scanners
extends ClientHandler {
    private static final CeilingScanner ceilingScanner = new CeilingScanner();
    private static final VillageScanner villageScanner = new VillageScanner();
    private static final BiomeScanner biomes = new BiomeScanner();

    Scanners() {
        super("Scanners");
    }

    public static boolean isInside() {
        return ceilingScanner.isReallyInside();
    }

    public static boolean isInVillage() {
        return villageScanner.isInVillage();
    }

    public static int getBiomeArea() {
        return biomes.getBiomeArea();
    }

    public static Reference2IntOpenHashMap<BiomeInfo> getBiomes() {
        return biomes.getBiomes();
    }

    @Override
    public void process(class_1657 player) {
        long ticks = TickCounter.getTickCount();
        ceilingScanner.tick(ticks);
        villageScanner.tick(ticks);
        biomes.tick(ticks);
    }

    @Override
    protected void gatherDiagnostics(Collection<String> left, Collection<String> right, Collection<TimerEMA> timers) {
        right.add("");
        right.add(class_124.field_1080 + "Biome Survey");
        for (Reference2IntMap.Entry e : biomes.getBiomes().reference2IntEntrySet()) {
            right.add(class_124.field_1080 + String.format("%s [%d]", ((BiomeInfo)e.getKey()).getBiomeId(), e.getIntValue()));
        }
    }
}

