/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing;

import java.util.Collection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.gui.sound.IndividualSoundControlScreen;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.Singleton;
import org.orecruncher.dsurround.lib.TickCounter;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.math.LoggingTimerEMA;
import org.orecruncher.dsurround.lib.math.TimerEMA;
import org.orecruncher.dsurround.lib.world.WorldUtils;
import org.orecruncher.dsurround.processing.AreaBlockEffects;
import org.orecruncher.dsurround.processing.BiomeSoundHandler;
import org.orecruncher.dsurround.processing.ClientHandler;
import org.orecruncher.dsurround.processing.EntityEffectHandler;
import org.orecruncher.dsurround.processing.PlayerHandler;
import org.orecruncher.dsurround.processing.Scanners;
import org.orecruncher.dsurround.sound.SoundFactoryBuilder;

@Environment(value=EnvType.CLIENT)
public class Handlers {
    private static final IModLog LOGGER = Client.LOGGER.createChild(Handlers.class);
    private static final Singleton<Handlers> INSTANCE = new Singleton<Handlers>(Handlers::new);
    private final ObjectArray<ClientHandler> effectHandlers = new ObjectArray();
    private final LoggingTimerEMA handlerTimer = new LoggingTimerEMA("Handlers");
    private boolean isConnected = false;
    private boolean startupSoundPlayed = false;

    private Handlers() {
        this.init();
    }

    public static void initialize() {
        INSTANCE.get();
    }

    protected static class_1657 getPlayer() {
        return GameUtils.getPlayer();
    }

    private void register(ClientHandler handler) {
        this.effectHandlers.add(handler);
        LOGGER.debug("Registered handler [%s]", handler.getClass().getName());
    }

    private void init() {
        this.register(new Scanners());
        this.register(new PlayerHandler());
        this.register(new EntityEffectHandler());
        this.register(new BiomeSoundHandler());
        this.register(new AreaBlockEffects());
        ClientTickEvents.END_CLIENT_TICK.register(this::onTick);
        ClientEventHooks.COLLECT_DIAGNOSTICS.register(this::gatherDiagnostics);
        ClientPlayConnectionEvents.JOIN.register(this::onConnect);
        ClientPlayConnectionEvents.DISCONNECT.register(this::onDisconnect);
    }

    private void onConnect(class_634 handler, PacketSender sender, class_310 client) {
        if (this.isConnected) {
            LOGGER.warn("Attempt to initialize EffectManager when it is already initialized", new Object[0]);
            this.onDisconnect(null, null);
        }
        this.isConnected = true;
        for (ClientHandler h : this.effectHandlers) {
            h.connect0();
        }
    }

    private void onDisconnect(class_634 handler, class_310 client) {
        for (ClientHandler h : this.effectHandlers) {
            h.disconnect0();
        }
        this.isConnected = false;
    }

    protected boolean doTick() {
        return GameUtils.isInGame() && !GameUtils.getMC().method_1493() && !(GameUtils.getMC().field_1755 instanceof IndividualSoundControlScreen) && this.playerChunkLoaded();
    }

    protected boolean playerChunkLoaded() {
        class_1657 player = GameUtils.getPlayer();
        class_2338 pos = player.method_24515();
        return WorldUtils.isChunkLoaded(player.method_5770(), pos);
    }

    public void onTick(class_310 client) {
        if (!this.startupSoundPlayed) {
            this.handleStartupSound();
        }
        if (!this.doTick()) {
            return;
        }
        this.handlerTimer.begin();
        long tick = TickCounter.getTickCount();
        for (ClientHandler handler : this.effectHandlers) {
            long mark = System.nanoTime();
            if (handler.doTick(tick)) {
                handler.process(Handlers.getPlayer());
            }
            handler.updateTimer(System.nanoTime() - mark);
        }
        this.handlerTimer.end();
    }

    private void handleStartupSound() {
        class_310 client = GameUtils.getMC();
        if (client.method_18506() != null) {
            return;
        }
        this.startupSoundPlayed = true;
        Client.SoundConfig.getRandomStartupSound().ifPresent(id -> {
            class_1109 sound = SoundFactoryBuilder.create(id).build().createAsAdditional();
            client.method_1483().method_4873((class_1113)sound);
        });
    }

    public void gatherDiagnostics(Collection<String> left, Collection<String> right, Collection<TimerEMA> timers) {
        timers.add(this.handlerTimer);
        this.effectHandlers.forEach(h -> {
            h.gatherDiagnostics(left, right, timers);
            timers.add(h.getTimer());
        });
    }
}

