/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing;

import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.config.EntityEffectLibrary;
import org.orecruncher.dsurround.effects.entity.EntityEffectInfo;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.processing.ClientHandler;

@Environment(value=EnvType.CLIENT)
public class EntityEffectHandler
extends ClientHandler {
    private static final IModLog LOGGER = Client.LOGGER.createChild(EntityEffectHandler.class);

    EntityEffectHandler() {
        super("EntityEffect Handler");
    }

    @Override
    public void process(class_1657 player) {
        int range = Client.Config.entityEffects.entityEffectRange;
        class_1937 world = player.method_5770();
        class_238 worldBox = class_238.method_29968((class_243)player.method_33571()).method_1014((double)(range * 2));
        List loadedEntities = world.method_8390(class_1309.class, worldBox, entity -> true);
        for (class_1309 entity2 : loadedEntities) {
            boolean hasInfo = EntityEffectLibrary.doesEntityEffectInfoExist(entity2);
            boolean inRange = entity2.method_24516((class_1297)player, (double)range);
            EntityEffectInfo info = null;
            if (!hasInfo && entity2.method_5805()) {
                if (inRange && !entity2.method_7325()) {
                    LOGGER.debug("Obtaining effect info for %s (id %d)", entity2.getClass().getSimpleName(), entity2.method_5628());
                    EntityEffectInfo finalInfo = info = EntityEffectLibrary.getEntityEffectInfo(entity2);
                    LOGGER.debug(() -> {
                        String txt = finalInfo.getEffects().stream().map(e -> e.getClass().getSimpleName()).collect(Collectors.joining(","));
                        return String.format("Effects attached: %s", txt);
                    });
                }
            } else if (hasInfo) {
                info = EntityEffectLibrary.getEntityEffectInfo(entity2);
            }
            if (info == null) continue;
            if (inRange && info.isAlive() && !entity2.method_7325()) {
                info.tick();
                continue;
            }
            LOGGER.debug("Clearing effect info for %s (id %d)", entity2.getClass().getSimpleName(), entity2.method_5628());
            info.deactivate();
            EntityEffectLibrary.clearEntityEffectInfo(entity2);
        }
    }
}

