/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import org.orecruncher.dsurround.lib.math.TimerEMA;
import org.orecruncher.dsurround.lib.random.XorShiftRandom;

@Environment(value=EnvType.CLIENT)
abstract class ClientHandler {
    protected static final Random RANDOM = XorShiftRandom.current();
    private final String handlerName;
    private final TimerEMA timer;

    ClientHandler(String name) {
        this.handlerName = name;
        this.timer = new TimerEMA(this.handlerName);
    }

    public TimerEMA getTimer() {
        return this.timer;
    }

    public final String getHandlerName() {
        return this.handlerName;
    }

    public boolean doTick(long tick) {
        return true;
    }

    public void process(class_1657 player) {
    }

    public void onConnect() {
    }

    public void onDisconnect() {
    }

    protected void gatherDiagnostics(Collection<String> left, Collection<String> right, Collection<TimerEMA> timers) {
    }

    final void updateTimer(long nanos) {
        this.timer.update(nanos);
    }

    final void connect0() {
        this.onConnect();
    }

    final void disconnect0() {
        this.onDisconnect();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getHandlerName()).toString();
    }
}

