/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing;

import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.util.Collection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import org.orecruncher.dsurround.config.BiomeLibrary;
import org.orecruncher.dsurround.config.InternalBiomes;
import org.orecruncher.dsurround.config.SoundEventType;
import org.orecruncher.dsurround.config.biome.BiomeInfo;
import org.orecruncher.dsurround.lib.TickCounter;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.math.TimerEMA;
import org.orecruncher.dsurround.processing.BiomeSoundEmitter;
import org.orecruncher.dsurround.processing.ClientHandler;
import org.orecruncher.dsurround.processing.Scanners;
import org.orecruncher.dsurround.processing.scanner.BiomeScanner;
import org.orecruncher.dsurround.sound.ISoundFactory;
import org.orecruncher.dsurround.sound.MinecraftAudioPlayer;

@Environment(value=EnvType.CLIENT)
public final class BiomeSoundHandler
extends ClientHandler {
    public static final int SCAN_INTERVAL = 4;
    public static final int MOOD_SOUND_MIN_RANGE = 8;
    public static final int MOOD_SOUND_MAX_RANGE = 16;
    private static final Object2FloatOpenHashMap<ISoundFactory> WORK_MAP = new Object2FloatOpenHashMap(8, 1.0f);
    private final ObjectArray<BiomeSoundEmitter> emitters = new ObjectArray(8);

    BiomeSoundHandler() {
        super("Biome Sounds");
    }

    private boolean doBiomeSounds() {
        return true;
    }

    private void generateBiomeSounds() {
        float area = Scanners.getBiomeArea();
        for (Reference2IntMap.Entry kvp : Scanners.getBiomes().reference2IntEntrySet()) {
            Collection<ISoundFactory> acoustics = ((BiomeInfo)kvp.getKey()).findBiomeSoundMatches();
            float volume = 0.05f + 0.95f * ((float)kvp.getIntValue() / area);
            for (ISoundFactory acoustic : acoustics) {
                WORK_MAP.addTo((Object)acoustic, volume);
            }
        }
    }

    @Override
    public void process(class_1657 player) {
        this.emitters.forEach(BiomeSoundEmitter::tick);
        if (TickCounter.getTickCount() % 4L == 0L) {
            this.handleBiomeSounds(player);
        }
    }

    @Override
    public void onConnect() {
        this.clearSounds();
    }

    @Override
    public void onDisconnect() {
        this.clearSounds();
    }

    private void handleBiomeSounds(class_1657 player) {
        WORK_MAP.clear();
        if (player.method_5805()) {
            boolean biomeSounds = this.doBiomeSounds();
            if (biomeSounds) {
                this.generateBiomeSounds();
            }
            BiomeInfo internalPlayerBiomeInfo = BiomeLibrary.getBiomeInfo(InternalBiomes.PLAYER);
            BiomeInfo internalVillageBiomeInfo = BiomeLibrary.getBiomeInfo(InternalBiomes.VILLAGE);
            ObjectArray<ISoundFactory> playerSounds = new ObjectArray<ISoundFactory>();
            playerSounds.addAll(internalPlayerBiomeInfo.findBiomeSoundMatches());
            playerSounds.addAll(internalVillageBiomeInfo.findBiomeSoundMatches());
            playerSounds.forEach(fx -> WORK_MAP.put(fx, 1.0f));
            if (biomeSounds) {
                BiomeInfo playerBiome = BiomeScanner.playerLogicBiomeInfo();
                this.handleAddOnSounds(player, playerBiome);
                this.handleAddOnSounds(player, internalPlayerBiomeInfo);
                this.handleAddOnSounds(player, internalVillageBiomeInfo);
            }
        }
        this.queueAmbientSounds();
    }

    private void handleAddOnSounds(class_1657 player, BiomeInfo info) {
        class_1109 instance;
        ISoundFactory sound = info.getExtraSound(SoundEventType.MOOD, RANDOM);
        if (sound != null) {
            instance = sound.createAsMood((class_1297)player, 8, 16);
            MinecraftAudioPlayer.INSTANCE.play((class_1113)instance);
        }
        if ((sound = info.getExtraSound(SoundEventType.ADDITION, RANDOM)) != null) {
            instance = sound.createAsAdditional();
            MinecraftAudioPlayer.INSTANCE.play((class_1113)instance);
        }
    }

    private void queueAmbientSounds() {
        this.emitters.removeIf(entry -> {
            if (entry.isDonePlaying()) {
                return true;
            }
            float volume = WORK_MAP.getFloat((Object)entry.getSoundEvent());
            if (volume > 0.0f) {
                entry.setVolumeScale(volume);
                if (entry.isFading()) {
                    entry.unfade();
                }
                WORK_MAP.removeFloat((Object)entry.getSoundEvent());
            } else if (!entry.isFading()) {
                entry.fade();
            }
            return false;
        });
        WORK_MAP.forEach((fx, volume) -> {
            BiomeSoundEmitter e = new BiomeSoundEmitter((ISoundFactory)fx);
            e.setVolumeScale(volume.floatValue());
            this.emitters.add(e);
        });
    }

    public void clearSounds() {
        this.emitters.forEach(BiomeSoundEmitter::stop);
        this.emitters.clear();
        WORK_MAP.clear();
        MinecraftAudioPlayer.INSTANCE.stopAll();
    }

    @Override
    protected void gatherDiagnostics(Collection<String> left, Collection<String> right, Collection<TimerEMA> timers) {
        left.add("");
        this.emitters.forEach(backgroundAcousticEmitter -> left.add("EMITTER: " + backgroundAcousticEmitter.toString()));
    }

    static {
        WORK_MAP.defaultReturnValue(0.0f);
    }
}

