/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.sound.BackgroundSoundLoop;
import org.orecruncher.dsurround.sound.ISoundFactory;
import org.orecruncher.dsurround.sound.MinecraftAudioPlayer;

@Environment(value=EnvType.CLIENT)
public final class BiomeSoundEmitter {
    private final ISoundFactory soundEvent;
    private final BackgroundSoundLoop acousticSource;
    private boolean done = false;

    public BiomeSoundEmitter(ISoundFactory event) {
        this.soundEvent = event;
        this.acousticSource = event.createBackgroundSoundLoop();
    }

    public void tick() {
        boolean isPlaying = MinecraftAudioPlayer.INSTANCE.isPlaying((class_1113)this.acousticSource);
        if (isPlaying) {
            return;
        }
        if (this.isFading()) {
            this.done = true;
            return;
        }
        MinecraftAudioPlayer.INSTANCE.play((class_1113)this.acousticSource);
    }

    public void setVolumeScale(float scale) {
        this.acousticSource.setScaleTarget(scale);
    }

    public void fade() {
        Client.LOGGER.debug("FADE: %s", this.acousticSource.toString());
        this.acousticSource.fadeOut();
    }

    public boolean isFading() {
        return this.acousticSource.isFading();
    }

    public void unfade() {
        Client.LOGGER.debug("UNFADE: %s", this.acousticSource.toString());
        this.acousticSource.fadeIn();
    }

    public boolean isDonePlaying() {
        return this.done || this.acousticSource.method_4793();
    }

    public void stop() {
        MinecraftAudioPlayer.INSTANCE.stop((class_1113)this.acousticSource);
        this.done = true;
    }

    public ISoundFactory getSoundEvent() {
        return this.soundEvent;
    }

    public String toString() {
        return this.acousticSource.toString();
    }
}

