/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.processing;

import java.util.Collection;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.lib.math.TimerEMA;
import org.orecruncher.dsurround.lib.scanner.ClientPlayerContext;
import org.orecruncher.dsurround.lib.scanner.ScanContext;
import org.orecruncher.dsurround.processing.ClientHandler;
import org.orecruncher.dsurround.processing.misc.BlockEffectManager;
import org.orecruncher.dsurround.processing.scanner.AlwaysOnBlockEffectScanner;
import org.orecruncher.dsurround.processing.scanner.RandomBlockEffectScanner;

public class AreaBlockEffects
extends ClientHandler {
    protected ClientPlayerContext locus;
    protected BlockEffectManager blockEffects;
    protected RandomBlockEffectScanner nearEffects;
    protected RandomBlockEffectScanner farEffects;
    protected AlwaysOnBlockEffectScanner alwaysOn;

    AreaBlockEffects() {
        super("Area Block Effects");
        ClientEventHooks.BLOCK_UPDATE.register(this::blockUpdates);
    }

    @Override
    public void process(class_1657 player) {
        this.blockEffects.tick(player);
        this.nearEffects.tick();
        this.farEffects.tick();
        this.alwaysOn.tick();
    }

    @Override
    public void onConnect() {
        this.locus = new ClientPlayerContext();
        this.blockEffects = new BlockEffectManager();
        this.alwaysOn = new AlwaysOnBlockEffectScanner((ScanContext)this.locus, this.blockEffects, Client.Config.blockEffects.blockEffectRange);
        this.nearEffects = new RandomBlockEffectScanner((ScanContext)this.locus, this.blockEffects, 16);
        this.farEffects = new RandomBlockEffectScanner((ScanContext)this.locus, this.blockEffects, 32);
    }

    @Override
    public void onDisconnect() {
        this.locus = null;
        this.blockEffects = null;
        this.alwaysOn = null;
        this.nearEffects = null;
        this.farEffects = null;
    }

    private void blockUpdates(Collection<class_2338> blockPos) {
        if (this.alwaysOn != null) {
            blockPos.forEach(this.alwaysOn::onBlockUpdate);
        }
    }

    @Override
    protected void gatherDiagnostics(Collection<String> left, Collection<String> right, Collection<TimerEMA> timers) {
        left.add(class_124.field_1076 + String.format("Total Effects: %d", this.blockEffects.count()));
    }
}

