/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.world;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.event.lifecycle.LoadedChunksCache;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2902;
import net.minecraft.class_4076;
import net.minecraft.class_5217;
import org.orecruncher.dsurround.mixins.core.MixinClientWorldProperties;

public class WorldUtils {
    public static final float COLD_THRESHOLD = 0.2f;
    public static final float SNOW_THRESHOLD = 0.15f;

    @Environment(value=EnvType.CLIENT)
    public static boolean isSuperFlat(class_1937 world) {
        class_5217 info = world.method_8401();
        return info instanceof MixinClientWorldProperties && ((MixinClientWorldProperties)info).isFlatWorld();
    }

    public static class_2338 getTopSolidOrLiquidBlock(class_1937 world, class_2338 pos) {
        return world.method_8598(class_2902.class_2903.field_13197, pos);
    }

    public static float getTemperatureAt(class_1937 world, class_2338 pos) {
        return world.method_22385().method_22393(pos).method_21740(pos);
    }

    public static int getPrecipitationHeight(class_1937 world, class_2338 pos) {
        return world.method_8624(class_2902.class_2903.field_13197, pos.method_10263(), pos.method_10260());
    }

    @Environment(value=EnvType.CLIENT)
    public static List<class_2586> getLoadedBlockEntities(class_1937 world, Predicate<class_2586> predicate) {
        return ((LoadedChunksCache)world).fabric_getLoadedChunks().stream().flatMap(chunk -> chunk.method_12214().values().stream()).filter(predicate).collect(Collectors.toList());
    }

    public static class_1959.class_1963 getCurrentPrecipitationAt(class_1937 world, class_2338 pos) {
        if (!world.method_8419()) {
            return class_1959.class_1963.field_9384;
        }
        class_1959 biome = world.method_23753(pos);
        if (biome.method_8694() == class_1959.class_1963.field_9384) {
            return class_1959.class_1963.field_9384;
        }
        int p = WorldUtils.getPrecipitationHeight(world, pos);
        if (p > pos.method_10264()) {
            return class_1959.class_1963.field_9384;
        }
        float temp = WorldUtils.getTemperatureAt(world, pos);
        return WorldUtils.isSnowTemperature(temp) ? class_1959.class_1963.field_9383 : class_1959.class_1963.field_9382;
    }

    public static boolean isColdTemperature(float temp) {
        return temp < 0.2f;
    }

    public static boolean isSnowTemperature(float temp) {
        return temp < 0.15f;
    }

    public static boolean isChunkLoaded(class_1937 world, class_2338 pos) {
        int chunkX = class_4076.method_18675((int)pos.method_10263());
        int chunkZ = class_4076.method_18675((int)pos.method_10260());
        return world.method_8398().method_12123(chunkX, chunkZ);
    }
}

