/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.version;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import org.orecruncher.dsurround.lib.version.VersionData;

public class VersionInformation {
    private static final Codec<Map<Version, String>> CODEC_RELEASES = Codec.unboundedMap(VersionData.CODEC, (Codec)Codec.STRING).stable();
    private static final Codec<Map<Version, Map<Version, String>>> MAJOR_VERSION_RELEASES = Codec.unboundedMap(VersionData.CODEC, CODEC_RELEASES).stable();
    private static final Codec<Map<Version, Version>> RECOMMENDATION = Codec.unboundedMap(VersionData.CODEC, VersionData.CODEC).stable();
    public static Codec<VersionInformation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("downloadLocation").forGetter(info -> info.downloadLocation), (App)MAJOR_VERSION_RELEASES.fieldOf("releases").forGetter(info -> info.releases), (App)RECOMMENDATION.fieldOf("recommend").forGetter(info -> info.recommended)).apply((Applicative)instance, VersionInformation::new));
    public final String downloadLocation;
    public final Map<Version, Map<Version, String>> releases;
    public final Map<Version, Version> recommended;

    VersionInformation(String downloadLocation, Map<Version, Map<Version, String>> releases, Map<Version, Version> recommended) {
        this.downloadLocation = downloadLocation;
        this.releases = releases;
        this.recommended = recommended;
    }

    public Optional<Pair<Version, String>> getNewestVersion(Version minecraftVersion, Version modVersion) {
        Version recommendation = this.recommended.get(minecraftVersion);
        if (recommendation == null) {
            return Optional.empty();
        }
        if (((SemanticVersion)modVersion).compareTo((SemanticVersion)recommendation) < 0) {
            String notes = null;
            Map<Version, String> releases = this.releases.get(minecraftVersion);
            if (releases != null && (notes = releases.get(recommendation)) == null) {
                notes = "";
            }
            return Optional.of(Pair.of((Object)recommendation, notes));
        }
        return Optional.empty();
    }
}

