/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.version;

import com.mojang.datafixers.util.Pair;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.fabricmc.loader.api.Version;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.lib.CodecExtensions;
import org.orecruncher.dsurround.lib.version.VersionInformation;

public class VersionChecker {
    public static Optional<String> getVersionData(URL url) {
        Optional<String> optional;
        block8: {
            InputStream in = url.openStream();
            try {
                byte[] bytes = in.readAllBytes();
                optional = Optional.of(new String(bytes, StandardCharsets.UTF_8));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    Client.LOGGER.error(t, "Unable to fetch version information from %s", url);
                    return Optional.empty();
                }
            }
            in.close();
        }
        return optional;
    }

    public static Optional<VersionInformation> getVersionInformation(URL url) {
        Optional<String> content = VersionChecker.getVersionData(url);
        if (content.isPresent()) {
            return CodecExtensions.deserialize(content.get(), VersionInformation.CODEC);
        }
        return Optional.empty();
    }

    public static Optional<VersionResult> getUpdateText(String displayName, Version minecraftVersion, Version modVersion, VersionInformation info) {
        displayName = class_124.method_539((String)displayName);
        Optional<Pair<Version, String>> result = info.getNewestVersion(minecraftVersion, modVersion);
        if (result.isEmpty()) {
            return Optional.empty();
        }
        Version version = (Version)result.get().getFirst();
        return Optional.of(new VersionResult(version, displayName, info.downloadLocation));
    }

    public static Optional<VersionResult> getUpdateText(String displayName, Version minecraftVersion, Version modVersion, URL dataLocation) {
        Optional<VersionInformation> info = VersionChecker.getVersionInformation(dataLocation);
        if (info.isEmpty()) {
            return Optional.empty();
        }
        return VersionChecker.getUpdateText(displayName, minecraftVersion, modVersion, info.get());
    }

    public static class VersionResult {
        public final Version version;
        public final String displayName;
        public final String downloadLocation;

        VersionResult(Version version, String displayName, String downloadLocation) {
            this.version = version;
            this.displayName = displayName;
            this.downloadLocation = downloadLocation;
        }

        public class_2561 getChatText() {
            String formattedText = class_1074.method_4662((String)"dsurround.text.NewVersion", (Object[])new Object[]{this.displayName, this.version.getFriendlyString(), this.downloadLocation});
            return class_2561.class_2562.method_10877((String)formattedText);
        }
    }
}

