/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.threading;

import java.util.function.Supplier;
import net.minecraft.class_3532;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.math.LoggingTimerEMA;

public final class Worker {
    private final Thread thread = new Thread(this::run);
    private final Runnable task;
    private final IModLog logger;
    private final int frequency;
    private Supplier<String> diagnosticString;
    private boolean stopProcessing;

    public Worker(String threadName, Runnable task, int frequencyMsecs, IModLog logger) {
        this.thread.setName(threadName);
        this.thread.setDaemon(true);
        this.task = task;
        this.frequency = frequencyMsecs;
        this.logger = logger;
        this.diagnosticString = () -> "";
    }

    private void run() {
        LoggingTimerEMA timeTrack = new LoggingTimerEMA(this.thread.getName());
        while (!this.stopProcessing) {
            timeTrack.begin();
            try {
                this.task.run();
            }
            catch (Throwable t) {
                this.logger.error(t, "Error processing %s!", this.thread.getName());
            }
            timeTrack.end();
            long sleepTime = (long)this.frequency - timeTrack.getLastSampleMSecs();
            long idleTime = class_3532.method_24156((long)sleepTime, (long)0L, (long)Long.MAX_VALUE);
            String track = timeTrack.toString();
            this.diagnosticString = () -> String.format("%s (idle for %dmsecs)", track, idleTime);
            if (sleepTime > 0L) {
                try {
                    Thread.sleep(sleepTime);
                    continue;
                }
                catch (Throwable ignore) {
                    this.logger.warn("Terminating thread [%s]", this.thread.getName());
                    return;
                }
            }
            this.logger.warn("[%s] is behind %d msecs", this.thread.getName(), Math.abs(sleepTime));
        }
    }

    public void start() {
        this.thread.start();
    }

    public void stop() {
        try {
            this.stopProcessing = true;
            this.thread.join();
        }
        catch (Throwable t) {
            this.logger.warn("Error stopping worker thread [%s]", this.thread.getName());
        }
    }

    public String getDiagnosticString() {
        return this.diagnosticString.get();
    }
}

