/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.scanner;

import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.Random;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3614;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.random.XorShiftRandom;
import org.orecruncher.dsurround.lib.scanner.ScanContext;

@Environment(value=EnvType.CLIENT)
public abstract class Scanner {
    protected static final Set<class_2680> BLOCKSTATES_TO_IGNORE = new ReferenceArraySet(3);
    private static final int MAX_BLOCKS_TICK = 6000;
    protected final String name;
    protected final int xRange;
    protected final int yRange;
    protected final int zRange;
    protected final int xSize;
    protected final int ySize;
    protected final int zSize;
    protected final int blocksPerTick;
    protected final int volume;
    protected final ScanContext locus;
    protected final Random random = new XorShiftRandom();
    protected final class_2338.class_2339 workingPos = new class_2338.class_2339();

    public Scanner(ScanContext locus, String name, int range) {
        this(locus, name, range, 0);
    }

    public Scanner(ScanContext locus, String name, int range, int blocksPerTick) {
        this(locus, name, range, range, range, blocksPerTick);
    }

    public Scanner(ScanContext locus, String name, int xRange, int yRange, int zRange) {
        this(locus, name, xRange, yRange, zRange, 0);
    }

    public Scanner(ScanContext locus, String name, int xRange, int yRange, int zRange, int blocksPerTick) {
        this.name = name;
        this.xRange = xRange;
        this.yRange = yRange;
        this.zRange = zRange;
        this.xSize = xRange * 2;
        this.ySize = yRange * 2;
        this.zSize = zRange * 2;
        this.volume = this.xSize * this.ySize * this.zSize;
        this.blocksPerTick = blocksPerTick == 0 ? Math.min(this.volume / 20, 6000) : Math.min(blocksPerTick, 6000);
        this.locus = locus;
    }

    public int getVolume() {
        return this.volume;
    }

    public abstract void blockScan(class_2680 var1, class_2338 var2, Random var3);

    protected boolean interestingBlock(class_2680 state) {
        return state.method_26207() != class_3614.field_15959;
    }

    public void preScan() {
    }

    public void postScan() {
    }

    public void tick() {
        class_2338 pos;
        this.preScan();
        class_1937 provider = this.locus.getWorld();
        for (int count = 0; count < this.blocksPerTick && (pos = this.nextPos(this.workingPos, this.random)) != null; ++count) {
            class_2680 state = provider.method_8320(pos);
            if (BLOCKSTATES_TO_IGNORE.contains(state) || !this.interestingBlock(state)) continue;
            this.blockScan(state, pos, this.random);
        }
        this.postScan();
    }

    @Nullable
    protected abstract class_2338 nextPos(class_2338.class_2339 var1, Random var2);

    static {
        BLOCKSTATES_TO_IGNORE.add(class_2246.field_10243.method_9564());
        BLOCKSTATES_TO_IGNORE.add(class_2246.field_10543.method_9564());
        BLOCKSTATES_TO_IGNORE.add(class_2246.field_10124.method_9564());
    }
}

