/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.scanner;

import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.scanner.ComplementsPointIterator;
import org.orecruncher.dsurround.lib.scanner.Cuboid;
import org.orecruncher.dsurround.lib.scanner.CuboidPointIterator;
import org.orecruncher.dsurround.lib.scanner.ScanContext;
import org.orecruncher.dsurround.lib.scanner.Scanner;

@Environment(value=EnvType.CLIENT)
public abstract class CuboidScanner
extends Scanner {
    protected boolean scanFinished = false;
    protected Cuboid activeCuboid;
    protected CuboidPointIterator fullRange;
    protected class_2338 lastPos;
    protected class_2960 lastReference = new class_2960("dsurround:aintnothin");

    protected CuboidScanner(ScanContext locus, String name, int range, int blocksPerTick) {
        super(locus, name, range, blocksPerTick);
    }

    protected CuboidScanner(ScanContext locus, String name, int xRange, int yRange, int zRange) {
        super(locus, name, xRange, yRange, zRange);
    }

    protected CuboidScanner(ScanContext locus, String name, int xSize, int ySize, int zSize, int blocksPerTick) {
        super(locus, name, xSize, ySize, zSize, blocksPerTick);
    }

    public boolean isScanFinished() {
        return this.scanFinished;
    }

    protected class_2338[] getMinMaxPointsForVolume(class_2338 pos) {
        class_2338 min = pos.method_10069(-this.xRange, -this.yRange, -this.zRange);
        class_2338 max = pos.method_10069(this.xRange, this.yRange, this.zRange);
        if (this.locus.isOutOfHeightLimit(min.method_10264())) {
            min = new class_2338(min.method_10263(), this.locus.clampHeight(min.method_10264()), min.method_10260());
        }
        return new class_2338[]{min, max};
    }

    protected Cuboid getVolumeFor(class_2338 pos) {
        class_2338[] points = this.getMinMaxPointsForVolume(pos);
        return new Cuboid(points);
    }

    protected void resetFullScan() {
        this.lastPos = this.locus.getCenter();
        this.lastReference = this.locus.getReference();
        this.scanFinished = false;
        class_2338[] points = this.getMinMaxPointsForVolume(this.lastPos);
        this.activeCuboid = new Cuboid(points);
        this.fullRange = new CuboidPointIterator(points);
    }

    @Override
    public void tick() {
        class_2338 playerPos = this.locus.getCenter();
        if (this.locus.isOutOfHeightLimit(playerPos.method_10264())) {
            this.fullRange = null;
        } else if (this.fullRange == null || this.locus.getReference() != this.lastReference) {
            this.resetFullScan();
            super.tick();
        } else if (this.lastPos.equals((Object)playerPos)) {
            if (!this.scanFinished) {
                super.tick();
            }
        } else {
            Cuboid newVolume;
            Cuboid oldVolume = this.activeCuboid != null ? this.activeCuboid : this.getVolumeFor(this.lastPos);
            Cuboid intersect = oldVolume.intersection(newVolume = this.getVolumeFor(playerPos));
            if (intersect == null || oldVolume.volume() < (oldVolume.volume() - intersect.volume()) * 2L) {
                this.resetFullScan();
                super.tick();
            } else if (this.scanFinished) {
                this.lastPos = playerPos;
                this.activeCuboid = newVolume;
                this.updateScan(newVolume, oldVolume, intersect);
            } else {
                super.tick();
            }
        }
    }

    public boolean doBlockUnscan() {
        return false;
    }

    public void blockUnscan(class_2680 state, class_2338 pos, Random rand) {
    }

    protected void updateScan(Cuboid newVolume, Cuboid oldVolume, Cuboid intersect) {
        class_2680 state;
        class_2338 point;
        class_1937 provider = this.locus.getWorld();
        if (this.doBlockUnscan()) {
            ComplementsPointIterator newOutOfRange = new ComplementsPointIterator(oldVolume, intersect);
            point = newOutOfRange.next();
            while (point != null) {
                if (!this.locus.isOutOfHeightLimit(point.method_10264()) && this.interestingBlock(state = provider.method_8320(point))) {
                    this.blockUnscan(state, point, this.random);
                }
                point = newOutOfRange.next();
            }
        }
        ComplementsPointIterator newInRange = new ComplementsPointIterator(newVolume, intersect);
        point = newInRange.next();
        while (point != null) {
            if (!this.locus.isOutOfHeightLimit(point.method_10264()) && this.interestingBlock(state = provider.method_8320(point))) {
                this.blockScan(state, point, this.random);
            }
            point = newInRange.next();
        }
        this.scanFinished = true;
    }

    @Override
    @Nullable
    protected class_2338 nextPos(class_2338.class_2339 workingPos, Random rand) {
        class_2338 point;
        if (this.scanFinished) {
            return null;
        }
        int checked = 0;
        while ((point = this.fullRange.peek()) != null) {
            this.fullRange.next();
            if (!this.locus.isOutOfHeightLimit(point.method_10264())) {
                return point;
            }
            if (++checked < this.blocksPerTick) continue;
            return null;
        }
        this.scanFinished = true;
        return null;
    }

    protected boolean isInteresting(class_2338 pos, class_2680 state) {
        if (this.activeCuboid == null) {
            return false;
        }
        if (!this.activeCuboid.contains(pos)) {
            return false;
        }
        return this.interestingBlock(state);
    }

    public void onBlockUpdate(class_2338 pos) {
        try {
            class_2680 state;
            if (this.activeCuboid != null && this.activeCuboid.contains(pos) && this.isInteresting(pos, state = this.locus.getWorld().method_8320(pos))) {
                this.blockScan(state, pos, this.random);
            }
        }
        catch (Throwable t) {
            this.locus.getLogger().error(t, "onBlockUpdate() error", new Object[0]);
        }
    }
}

