/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.scanner;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.BlockPosUtil;

@Environment(value=EnvType.CLIENT)
public class Cuboid {
    protected final class_2338[] vertices = new class_2338[8];
    protected final int volume;
    protected final class_2338 minPoint;
    protected final class_2338 maxPoint;

    public Cuboid(class_2338[] points) {
        this(points[0], points[1]);
    }

    public Cuboid(class_2338 vx1, class_2338 vx2) {
        this.minPoint = BlockPosUtil.createMinPoint(vx1, vx2);
        this.maxPoint = BlockPosUtil.createMaxPoint(vx1, vx2);
        class_2338 t = this.maxPoint.method_10059((class_2382)this.minPoint);
        this.volume = t.method_10263() * t.method_10264() * t.method_10260();
        this.vertices[0] = this.minPoint;
        this.vertices[1] = this.maxPoint;
        this.vertices[2] = new class_2338(this.minPoint.method_10263(), this.maxPoint.method_10264(), this.maxPoint.method_10260());
        this.vertices[3] = new class_2338(this.maxPoint.method_10263(), this.minPoint.method_10264(), this.minPoint.method_10260());
        this.vertices[4] = new class_2338(this.maxPoint.method_10263(), this.minPoint.method_10264(), this.maxPoint.method_10260());
        this.vertices[5] = new class_2338(this.minPoint.method_10263(), this.minPoint.method_10264(), this.maxPoint.method_10260());
        this.vertices[6] = new class_2338(this.minPoint.method_10263(), this.maxPoint.method_10264(), this.minPoint.method_10260());
        this.vertices[7] = new class_2338(this.maxPoint.method_10263(), this.maxPoint.method_10264(), this.minPoint.method_10260());
    }

    public boolean contains(class_2338 p) {
        return BlockPosUtil.contains(p, this.minPoint, this.maxPoint);
    }

    public class_2338 maximum() {
        return this.maxPoint;
    }

    public class_2338 minimum() {
        return this.minPoint;
    }

    public long volume() {
        return this.volume;
    }

    @Nullable
    public Cuboid intersection(Cuboid o) {
        class_2338 vx1 = null;
        for (class_2338 vx : this.vertices) {
            if (!o.contains(vx)) continue;
            vx1 = vx;
            break;
        }
        if (vx1 == null) {
            return null;
        }
        class_2338 vx2 = null;
        for (class_2338 vx : o.vertices) {
            if (!this.contains(vx) || !BlockPosUtil.canFormCuboid(vx, vx1)) continue;
            vx2 = vx;
            break;
        }
        return vx2 == null ? null : new Cuboid(vx1, vx2);
    }
}

