/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.resources;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.lib.FrameworkUtils;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.resources.IResourceAccessor;

@Environment(value=EnvType.CLIENT)
public final class ResourceUtils {
    static final IModLog LOGGER = Client.LOGGER.createChild(ResourceUtils.class);

    public static Collection<IResourceAccessor> findConfigs(File diskPath, String config) {
        HashMap<class_2960, IResourceAccessor> accessorMap = new HashMap<class_2960, IResourceAccessor>();
        ResourceUtils.collectFromResourcePacks(accessorMap, config);
        ResourceUtils.collectFromDisk(accessorMap, diskPath, config);
        return new ArrayList<IResourceAccessor>(accessorMap.values());
    }

    private static void collectFromResourcePacks(Map<class_2960, IResourceAccessor> accessorMap, String config) {
        Collection<IResourceAccessor> results = ResourceUtils.findAssets(ns -> FabricLoader.getInstance().isModLoaded(ns), ns -> new class_2960(ns, String.format("dsconfigs/%s", config)));
        for (IResourceAccessor e : results) {
            accessorMap.put(e.location(), e);
        }
    }

    private static void collectFromDisk(Map<class_2960, IResourceAccessor> accessorMap, File diskPath, String config) {
        Collection<String> loadedMods = FrameworkUtils.getModIdList(true);
        for (String mod : loadedMods) {
            class_2960 location = new class_2960(mod, config);
            IResourceAccessor accessor = IResourceAccessor.createExternalResource(diskPath, location);
            if (!accessor.exists()) continue;
            accessorMap.put(location, accessor);
        }
    }

    public static Collection<IResourceAccessor> findSounds(String configId) {
        return ResourceUtils.findAssets(ns -> true, ns -> new class_2960(ns, configId));
    }

    private static Collection<IResourceAccessor> findAssets(Function<String, Boolean> namespaceFilter, Function<String, class_2960> identitySupplier) {
        ArrayList<IResourceAccessor> results = new ArrayList<IResourceAccessor>();
        class_3300 resourceManager = GameUtils.getMC().method_1478();
        for (String namespace : resourceManager.method_14487()) {
            try {
                if (!namespaceFilter.apply(namespace).booleanValue()) continue;
                class_2960 location = identitySupplier.apply(namespace);
                List resourceList = resourceManager.method_14489(location);
                try {
                    for (class_3298 resource : resourceList) {
                        try {
                            InputStream inputStream = resource.method_14482();
                            try {
                                byte[] asset = inputStream.readAllBytes();
                                IResourceAccessor accessor = IResourceAccessor.createRawBytes(location, asset);
                                results.add(accessor);
                            }
                            finally {
                                if (inputStream == null) continue;
                                inputStream.close();
                            }
                        }
                        catch (Throwable t) {
                            LOGGER.error(t, "Unable to read the asset %s from the resource pack", location);
                        }
                    }
                }
                catch (Throwable t) {
                    LOGGER.error(t, "Unable to enumerate resource for %s", location);
                }
            }
            catch (Throwable throwable) {}
        }
        return results;
    }
}

