/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.resources;

import java.io.InputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.apache.commons.io.IOUtils;
import org.orecruncher.dsurround.lib.resources.ResourceAccessorBase;

@Environment(value=EnvType.CLIENT)
final class ResourceAccessorJar
extends ResourceAccessorBase {
    final String asset;

    public ResourceAccessorJar(String rootContainer, class_2960 location) {
        this(location, String.format("/assets/%s/%s/%s", rootContainer, location.method_12836(), location.method_12832()));
    }

    public ResourceAccessorJar(class_2960 location, String asset) {
        super(location);
        this.asset = asset;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] getAsset() {
        try (InputStream stream = ResourceAccessorJar.class.getResourceAsStream(this.asset);){
            if (stream == null) return null;
            byte[] byArray = IOUtils.toByteArray((InputStream)stream);
            return byArray;
        }
        catch (Throwable t) {
            this.logError(t);
        }
        return null;
    }

    @Override
    public String toString() {
        return String.format("%s (%s)", super.toString(), this.asset);
    }
}

