/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.resources;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.orecruncher.dsurround.lib.resources.ResourceAccessorBase;

@Environment(value=EnvType.CLIENT)
final class ResourceAccessorExternal
extends ResourceAccessorBase {
    final Path filePath;

    public ResourceAccessorExternal(File root, class_2960 location) {
        super(location);
        this.filePath = Paths.get(root.getPath(), location.method_12836(), location.method_12832());
    }

    @Override
    public boolean exists() {
        return Files.exists(this.filePath, new LinkOption[0]);
    }

    @Override
    protected byte[] getAsset() {
        try {
            return Files.readAllBytes(this.filePath);
        }
        catch (Throwable t) {
            this.logError(t);
            return null;
        }
    }

    @Override
    public String toString() {
        return String.format("%s (%s)", super.toString(), this.filePath);
    }
}

