/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.serialization.Codec;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import joptsimple.internal.Strings;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.CodecExtensions;
import org.orecruncher.dsurround.lib.resources.ResourceAccessorBytes;
import org.orecruncher.dsurround.lib.resources.ResourceAccessorExternal;
import org.orecruncher.dsurround.lib.resources.ResourceUtils;

@Environment(value=EnvType.CLIENT)
public interface IResourceAccessor {
    public static IResourceAccessor createExternalResource(File root, class_2960 location) {
        return new ResourceAccessorExternal(root, location);
    }

    public static IResourceAccessor createRawBytes(class_2960 location, byte[] bytes) {
        return new ResourceAccessorBytes(location, bytes);
    }

    public static void process(Collection<IResourceAccessor> accessors, Consumer<IResourceAccessor> consumer) {
        for (IResourceAccessor accessor : accessors) {
            ResourceUtils.LOGGER.info("Processing %s", accessor);
            try {
                consumer.accept(accessor);
            }
            catch (Throwable t) {
                ResourceUtils.LOGGER.error(t, "Unable to complete processing of %s", accessor);
            }
        }
    }

    public class_2960 location();

    default public String asString() {
        byte[] bytes = this.asBytes();
        return bytes != null ? new String(bytes, Charset.defaultCharset()) : null;
    }

    public byte[] asBytes();

    default public <T> T as(Class<T> clazz) {
        String content = this.asString();
        if (!Strings.isNullOrEmpty((String)content)) {
            try {
                Gson gson = new GsonBuilder().create();
                return (T)gson.fromJson(content, clazz);
            }
            catch (Throwable t) {
                ResourceUtils.LOGGER.error(t, "Unable to complete processing of %s", this.toString());
            }
        }
        return null;
    }

    default public boolean exists() {
        return this.asBytes() != null;
    }

    default public <T> T as(Type type) {
        String content = this.asString();
        if (!Strings.isNullOrEmpty((String)content)) {
            try {
                Gson gson = new GsonBuilder().create();
                return (T)gson.fromJson(content, type);
            }
            catch (Throwable t) {
                ResourceUtils.LOGGER.error(t, "Unable to complete processing of %s", this.toString());
            }
        }
        return null;
    }

    @Nullable
    default public <T> T as(Codec<T> codec) {
        Optional<T> result;
        String content = this.asString();
        if (!Strings.isNullOrEmpty((String)content) && (result = CodecExtensions.deserialize(content, codec)).isPresent()) {
            return result.get();
        }
        return null;
    }

    default public void logError(Throwable t) {
        if (t instanceof FileNotFoundException) {
            ResourceUtils.LOGGER.debug("Asset not found for %s", this.toString());
        } else {
            ResourceUtils.LOGGER.error(t, "Unable to process asset %s", this.toString());
        }
    }
}

