/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.math;

public class EMA {
    private final String name;
    private final double factor;
    private double ema;

    public EMA() {
        this("UNNAMED");
    }

    public EMA(String name) {
        this(name, 100);
    }

    public EMA(String name, int periods) {
        this.name = name;
        this.factor = 2.0 / (double)(periods + 1);
        this.ema = Double.NaN;
    }

    public double update(double newValue) {
        this.ema = Double.isNaN(this.ema) ? newValue : newValue * this.factor + this.ema * (1.0 - this.factor);
        return this.ema;
    }

    public String name() {
        return this.name;
    }

    public double get() {
        return this.ema;
    }
}

