/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.logging;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.logging.IModLog;

public final class ModLog
implements IModLog {
    private static final Pattern REGEX_SPLIT = Pattern.compile("\\n");
    private final Marker marker;
    private final Logger logger;
    private boolean debugging;
    private int traceMask;

    public ModLog(Class<?> clazz) {
        this(Objects.requireNonNull(clazz).getSimpleName());
    }

    public ModLog(String name) {
        this.logger = LogManager.getLogger((String)Objects.requireNonNull(name));
        this.marker = MarkerManager.getMarker((String)"MOD");
    }

    private static void outputLines(@Nullable Marker marker, ILogIt out, String format, Object ... params) {
        String fmt = format;
        if (params != null && params.length > 0) {
            fmt = String.format(format, params);
        }
        for (String l : REGEX_SPLIT.split(fmt)) {
            out.log(marker, l, new Object[0]);
        }
    }

    public IModLog createChild(Class<?> child) {
        return new ChildLog(this, Objects.requireNonNull(child));
    }

    public void setDebug(boolean flag) {
        this.debugging = flag;
    }

    public void setTraceMask(int mask) {
        this.traceMask = mask;
    }

    public boolean testTrace(int mask) {
        return (this.traceMask & mask) != 0;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    @Override
    public void info(String msg, Object ... params) {
        this.info(this.marker, msg, params);
    }

    private void info(Marker marker, String msg, Object ... params) {
        ModLog.outputLines(marker, (arg_0, arg_1, arg_2) -> ((Logger)this.logger).info(arg_0, arg_1, arg_2), msg, params);
    }

    @Override
    public void info(Supplier<String> message) {
        this.info(this.marker, message);
    }

    private void info(Marker marker, Supplier<String> message) {
        ModLog.outputLines(marker, (arg_0, arg_1, arg_2) -> ((Logger)this.logger).info(arg_0, arg_1, arg_2), message.get(), new Object[0]);
    }

    @Override
    public void warn(String msg, Object ... params) {
        this.warn(this.marker, msg, params);
    }

    private void warn(Marker marker, String msg, Object ... params) {
        ModLog.outputLines(marker, (arg_0, arg_1, arg_2) -> ((Logger)this.logger).warn(arg_0, arg_1, arg_2), msg, params);
    }

    @Override
    public void warn(Supplier<String> message) {
        this.warn(this.marker, message);
    }

    private void warn(Marker marker, Supplier<String> message) {
        ModLog.outputLines(marker, (arg_0, arg_1, arg_2) -> ((Logger)this.logger).warn(arg_0, arg_1, arg_2), message.get(), new Object[0]);
    }

    @Override
    public void debug(String msg, Object ... params) {
        this.debug(this.marker, msg, params);
    }

    private void debug(Marker marker, String msg, Object ... params) {
        if (this.isDebugging()) {
            ModLog.outputLines(marker, (arg_0, arg_1, arg_2) -> ((Logger)this.logger).info(arg_0, arg_1, arg_2), msg, params);
        }
    }

    @Override
    public void debug(Supplier<String> message) {
        this.debug(this.marker, message);
    }

    private void debug(Marker marker, Supplier<String> message) {
        if (this.isDebugging()) {
            ModLog.outputLines(marker, (arg_0, arg_1, arg_2) -> ((Logger)this.logger).info(arg_0, arg_1, arg_2), message.get(), new Object[0]);
        }
    }

    @Override
    public void debug(int mask, String msg, Object ... params) {
        this.debug(this.marker, msg, params);
    }

    private void debug(Marker marker, int mask, String msg, Object ... params) {
        if (this.isDebugging() && this.testTrace(mask)) {
            ModLog.outputLines(marker, (arg_0, arg_1, arg_2) -> ((Logger)this.logger).info(arg_0, arg_1, arg_2), msg, params);
        }
    }

    @Override
    public void debug(int mask, Supplier<String> message) {
        this.debug(this.marker, message);
    }

    private void debug(Marker marker, int mask, Supplier<String> message) {
        if (this.isDebugging() && this.testTrace(mask)) {
            ModLog.outputLines(marker, (arg_0, arg_1, arg_2) -> ((Logger)this.logger).info(arg_0, arg_1, arg_2), message.get(), new Object[0]);
        }
    }

    @Override
    public void error(Throwable e, String msg, Object ... params) {
        this.error(this.marker, e, msg, params);
    }

    private void error(Marker marker, Throwable e, String msg, Object ... params) {
        ModLog.outputLines(marker, (arg_0, arg_1, arg_2) -> ((Logger)this.logger).error(arg_0, arg_1, arg_2), msg, params);
        e.printStackTrace();
    }

    @Override
    public void error(Throwable e, Supplier<String> message) {
        this.error(this.marker, e, message);
    }

    private void error(Marker marker, Throwable e, Supplier<String> message) {
        this.error(marker, e, message.get(), new Object[0]);
    }

    @FunctionalInterface
    private static interface ILogIt {
        public void log(Marker var1, String var2, Object ... var3);
    }

    private static class ChildLog
    implements IModLog {
        private final ModLog parent;
        private final Marker marker;

        ChildLog(ModLog parent, Class<?> child) {
            this.parent = parent;
            this.marker = MarkerManager.getMarker((String)child.getSimpleName());
        }

        @Override
        public void info(String msg, Object ... params) {
            this.parent.info(this.marker, msg, params);
        }

        @Override
        public void info(Supplier<String> message) {
            this.parent.info(this.marker, message);
        }

        @Override
        public void warn(String msg, Object ... params) {
            this.parent.warn(this.marker, msg, params);
        }

        @Override
        public void warn(Supplier<String> message) {
            this.parent.warn(this.marker, message);
        }

        @Override
        public void debug(String msg, Object ... params) {
            this.parent.debug(this.marker, msg, params);
        }

        @Override
        public void debug(Supplier<String> message) {
            this.parent.debug(this.marker, message);
        }

        @Override
        public void debug(int mask, String msg, Object ... params) {
            this.parent.debug(this.marker, mask, msg, params);
        }

        @Override
        public void debug(int mask, Supplier<String> message) {
            this.parent.debug(this.marker, mask, message);
        }

        @Override
        public void error(Throwable e, String msg, Object ... params) {
            this.parent.error(this.marker, e, msg, params);
        }

        @Override
        public void error(Throwable e, Supplier<String> message) {
            this.parent.error(this.marker, e, message);
        }
    }
}

