/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.config.clothapi;

import java.util.Collection;
import java.util.function.BiFunction;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.lib.config.ConfigElement;
import org.orecruncher.dsurround.lib.config.ConfigOptions;
import org.orecruncher.dsurround.lib.config.ConfigurationData;

@Environment(value=EnvType.CLIENT)
public class ClothAPIFactory
implements BiFunction<class_310, class_437, class_437> {
    private final class_2960 background;
    private final ConfigOptions options;
    private final ConfigurationData configData;

    public ClothAPIFactory(ConfigOptions options, ConfigurationData config) {
        this(options, config, null);
    }

    public ClothAPIFactory(ConfigOptions options, ConfigurationData config, @Nullable class_2960 background) {
        this.background = background;
        this.options = options;
        this.configData = config;
    }

    @Override
    public class_437 apply(class_310 MinecraftClient, class_437 screen) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(screen).setTitle(this.options.transformTitle()).setSavingRunnable(() -> {
            try {
                this.configData.save();
            }
            catch (Throwable t) {
                Client.LOGGER.error(t, "Unable to save configuration", new Object[0]);
            }
        });
        if (this.background != null) {
            builder.setDefaultBackgroundTexture(this.background);
        }
        this.generate(builder, this.configData);
        return builder.build();
    }

    protected void generate(ConfigBuilder builder, Object instance) {
        ConfigCategory root = builder.getOrCreateCategory(this.options.transformTitle());
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        Collection<ConfigElement<?>> properties = this.configData.getSpecification();
        for (ConfigElement<?> prop : properties) {
            ConfigElement.PropertyValue pv;
            FieldBuilder<?, ? extends AbstractConfigListEntry<?>> result;
            if (prop.isHidden()) continue;
            if (prop instanceof ConfigElement.PropertyGroup) {
                ConfigElement.PropertyGroup group = (ConfigElement.PropertyGroup)prop;
                result = this.generate(entryBuilder, group, instance);
                root.addEntry((AbstractConfigListEntry)result.build());
                continue;
            }
            if (!(prop instanceof ConfigElement.PropertyValue) || (result = this.generate(entryBuilder, pv = (ConfigElement.PropertyValue)prop, instance)) == null) continue;
            root.addEntry(result.build());
        }
    }

    protected SubCategoryBuilder generate(ConfigEntryBuilder builder, ConfigElement.PropertyGroup propertyGroup, Object instance) {
        SubCategoryBuilder categoryBuilder = builder.startSubCategory(this.options.transformPropertyGroup(propertyGroup.getElementNameKey())).setTooltip(this.options.transformTooltip(propertyGroup.getTooltip()));
        for (ConfigElement<?> prop : propertyGroup.getChildren()) {
            ConfigElement.PropertyValue pv;
            FieldBuilder<?, ? extends AbstractConfigListEntry<?>> result;
            if (prop.isHidden() || !(prop instanceof ConfigElement.PropertyValue) || (result = this.generate(builder, pv = (ConfigElement.PropertyValue)prop, propertyGroup.getInstance(instance))) == null) continue;
            categoryBuilder.add(result.build());
        }
        return categoryBuilder;
    }

    @Nullable
    protected FieldBuilder<?, ? extends AbstractConfigListEntry<?>> generate(ConfigEntryBuilder builder, ConfigElement.PropertyValue<?> pv, Object instance) {
        Object fieldBuilder = null;
        class_2561 name = this.options.transformProperty(pv.getElementNameKey());
        class_2561[] tooltip = this.options.transformTooltip(pv.getTooltip());
        if (pv instanceof ConfigElement.IntegerValue) {
            ConfigElement.IntegerValue v = (ConfigElement.IntegerValue)pv;
            fieldBuilder = pv.useSlider() ? builder.startIntSlider(name, ((Integer)v.getCurrentValue(instance)).intValue(), v.getMinValue(), v.getMaxValue()).setTooltip(tooltip).setDefaultValue(v::getDefaultValue).setSaveConsumer(data -> v.setCurrentValue(instance, data)) : builder.startIntField(name, ((Integer)v.getCurrentValue(instance)).intValue()).setTooltip(tooltip).setDefaultValue(((Integer)v.getDefaultValue()).intValue()).setMin(v.getMinValue()).setMax(v.getMaxValue()).setSaveConsumer(data -> v.setCurrentValue(instance, data));
        } else if (pv instanceof ConfigElement.DoubleValue) {
            ConfigElement.DoubleValue v = (ConfigElement.DoubleValue)pv;
            fieldBuilder = builder.startDoubleField(name, ((Double)v.getCurrentValue(instance)).doubleValue()).setTooltip(tooltip).setDefaultValue(((Double)v.getDefaultValue()).doubleValue()).setMin(v.getMinValue()).setMax(v.getMaxValue()).setSaveConsumer(data -> v.setCurrentValue(instance, data));
        } else if (pv instanceof ConfigElement.StringValue) {
            ConfigElement.StringValue v = (ConfigElement.StringValue)pv;
            fieldBuilder = builder.startStrField(name, (String)v.getCurrentValue(instance)).setTooltip(tooltip).setDefaultValue((String)v.getDefaultValue()).setSaveConsumer(data -> v.setCurrentValue(instance, data));
        } else if (pv instanceof ConfigElement.BooleanValue) {
            ConfigElement.BooleanValue v = (ConfigElement.BooleanValue)pv;
            fieldBuilder = builder.startBooleanToggle(name, ((Boolean)v.getCurrentValue(instance)).booleanValue()).setTooltip(tooltip).setDefaultValue(((Boolean)v.getDefaultValue()).booleanValue()).setSaveConsumer(data -> v.setCurrentValue(instance, data));
        } else if (pv instanceof ConfigElement.EnumValue) {
            ConfigElement.EnumValue enumValue = (ConfigElement.EnumValue)pv;
        }
        if (fieldBuilder != null) {
            fieldBuilder.requireRestart(pv.isRestartRequired());
        }
        return fieldBuilder;
    }
}

