/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.lib.config.ConfigElement;
import org.orecruncher.dsurround.lib.config.ConfigProcessor;

public abstract class ConfigurationData {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Reference2ObjectOpenHashMap<Class<?>, Collection<ConfigElement<?>>> specifications = new Reference2ObjectOpenHashMap();
    private static final Reference2ObjectOpenHashMap<Class<?>, ConfigurationData> configs = new Reference2ObjectOpenHashMap();
    private final transient String translationRoot;
    private final transient Path configFilePath;

    protected ConfigurationData(String translationRoot, Path configFilePath) {
        this.translationRoot = translationRoot;
        this.configFilePath = configFilePath;
    }

    @NotNull
    public static <T extends ConfigurationData> T getConfig(Class<T> clazz) {
        try {
            ConfigurationData config;
            block11: {
                config = (ConfigurationData)configs.get(clazz);
                if (config != null) {
                    return (T)config;
                }
                Constructor<T> ctor = clazz.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                config = (ConfigurationData)ctor.newInstance(new Object[0]);
                Collection<ConfigElement<?>> spec = ConfigProcessor.generateAccessors(config);
                specifications.put(clazz, spec);
                try {
                    if (!Files.exists(config.configFilePath, new LinkOption[0])) break block11;
                    try (BufferedReader reader = Files.newBufferedReader(config.configFilePath);){
                        config = (ConfigurationData)GSON.fromJson((Reader)reader, clazz);
                    }
                }
                catch (Throwable t) {
                    Client.LOGGER.error(t, "Unable to handle configuration", new Object[0]);
                }
            }
            config.postLoad();
            config.save();
            configs.put(clazz, (Object)config);
            return (T)config;
        }
        catch (Throwable t) {
            Client.LOGGER.error(t, "Unable to handle configuration", new Object[0]);
            return null;
        }
    }

    public Collection<ConfigElement<?>> getSpecification() {
        return (Collection)specifications.get(this.getClass());
    }

    public String getTranslationRoot() {
        return this.translationRoot;
    }

    public void save() {
        try {
            Files.createDirectories(this.configFilePath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.configFilePath, new OpenOption[0]);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (Throwable t) {
            Client.LOGGER.error(t, "Unable to save configurationL %s", t.getMessage());
        }
    }

    public void postLoad() {
    }

    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface EnumType {
        public Class<? extends Enum<?>> value();
    }

    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Hidden {
    }

    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Slider {
    }

    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Comment {
        public String value();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DefaultValue {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RestartRequired {
        public boolean client() default true;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DoubleRange {
        public double min();

        public double max() default 1.7976931348623157E308;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IntegerRange {
        public int min();

        public int max() default 0x7FFFFFFF;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Property {
        public String value() default "";
    }
}

