/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.config;

import java.lang.reflect.Field;
import java.util.Collection;
import joptsimple.internal.Strings;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.config.ConfigElement;
import org.orecruncher.dsurround.lib.config.ConfigValue;
import org.orecruncher.dsurround.lib.config.ConfigurationData;

public class ConfigProcessor {
    public static Collection<ConfigElement<?>> generateAccessors(ConfigurationData data) {
        GenerationContext ctx = new GenerationContext(data.getTranslationRoot());
        return ctx.generateLevel(data);
    }

    private static class GenerationContext {
        private final String translationRoot;

        GenerationContext(String translationRoot) {
            this.translationRoot = translationRoot;
        }

        public Collection<ConfigElement<?>> generateLevel(Object instance) {
            Field[] fields;
            ObjectArray elements = new ObjectArray();
            for (Field f : fields = instance.getClass().getFields()) {
                ConfigElement<?> element;
                ConfigurationData.Property property = f.getAnnotation(ConfigurationData.Property.class);
                if (property == null) continue;
                Class<?> fieldType = f.getType();
                if (!fieldType.isPrimitive()) {
                    if (fieldType.isEnum()) {
                        elements.add(this.processEnumInstance(property, instance, f));
                        continue;
                    }
                    elements.add(this.processClassInstance(property, instance, f));
                    continue;
                }
                if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                    element = this.processIntegerInstance(property, instance, f);
                } else if (fieldType == Double.class || fieldType == Float.class || fieldType == Double.TYPE || fieldType == Float.TYPE) {
                    element = this.processDoubleInstance(property, instance, f);
                } else if (fieldType == String.class) {
                    element = this.processStringInstance(property, instance, f);
                } else {
                    if (fieldType != Boolean.class && fieldType != Boolean.TYPE) continue;
                    element = this.processBooleanInstance(property, instance, f);
                }
                elements.add(element);
            }
            return elements;
        }

        GenerationContext createChild(String langKey) {
            return new GenerationContext(langKey);
        }

        private ConfigElement<?> processEnumInstance(ConfigurationData.Property property, Object instance, Field f) {
            ConfigurationData.EnumType enumType = f.getAnnotation(ConfigurationData.EnumType.class);
            if (enumType == null) {
                throw new RuntimeException("Enum field must have an EnumType annotation");
            }
            ConfigValue wrapper = new ConfigValue(f);
            return new ConfigElement.EnumValue(enumType.value(), instance, this.calculateLangKey(property, f), wrapper);
        }

        private ConfigElement<?> processClassInstance(ConfigurationData.Property property, Object instance, Field f) {
            ConfigValue wrapper = new ConfigValue(f);
            String key = this.calculateLangKey(property, f);
            GenerationContext ctx = this.createChild(key);
            Collection<ConfigElement<?>> subElements = ctx.generateLevel(wrapper.get(instance));
            return new ConfigElement.PropertyGroup(wrapper, key, subElements);
        }

        private ConfigElement<?> processStringInstance(ConfigurationData.Property property, Object instance, Field f) {
            ConfigValue<String> wrapper = new ConfigValue<String>(f);
            return new ConfigElement.StringValue(instance, this.calculateLangKey(property, f), wrapper);
        }

        private ConfigElement<?> processBooleanInstance(ConfigurationData.Property property, Object instance, Field f) {
            ConfigValue<Boolean> wrapper = new ConfigValue<Boolean>(f);
            return new ConfigElement.BooleanValue(instance, this.calculateLangKey(property, f), wrapper);
        }

        private ConfigElement<?> processIntegerInstance(ConfigurationData.Property property, Object instance, Field f) {
            ConfigValue<Integer> wrapper = new ConfigValue<Integer>(f);
            ConfigElement.IntegerValue element = new ConfigElement.IntegerValue(instance, this.calculateLangKey(property, f), wrapper);
            ConfigurationData.IntegerRange range = f.getAnnotation(ConfigurationData.IntegerRange.class);
            if (range != null) {
                element.setRange(range.min(), range.max());
            }
            return element;
        }

        private ConfigElement<?> processDoubleInstance(ConfigurationData.Property property, Object instance, Field f) {
            ConfigValue<Double> wrapper = new ConfigValue<Double>(f);
            ConfigElement.DoubleValue element = new ConfigElement.DoubleValue(instance, this.calculateLangKey(property, f), wrapper);
            ConfigurationData.DoubleRange range = f.getAnnotation(ConfigurationData.DoubleRange.class);
            if (range != null) {
                element.setRange(range.min(), range.max());
            }
            return element;
        }

        private String calculateLangKey(ConfigurationData.Property property, Field f) {
            String segment = f.getName();
            if (!Strings.isNullOrEmpty((String)property.value())) {
                segment = property.value();
            }
            return this.translationRoot + "." + segment;
        }
    }
}

