/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_5348;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.Localization;

public class ConfigOptions {
    private String translationRoot = "";
    private String titleStyle = "";
    private String subtitleStyle = "";
    private String propertyGroupStyle = "";
    private String propertyValueStyle = "";
    private String tooltipStyle = "";
    private int toolTipWidth = 300;
    private boolean stripTitle = true;
    private boolean stripPropertyGroups = true;
    private boolean stripPropertyValues = true;

    private static String strip(String txt) {
        String result = class_124.method_539((String)txt);
        return result != null ? result : txt;
    }

    public ConfigOptions setTitleStyle(class_124 ... style) {
        this.titleStyle = ConfigOptions.combine(style);
        return this;
    }

    public ConfigOptions setSubtitleStyle(class_124 ... style) {
        this.subtitleStyle = ConfigOptions.combine(style);
        return this;
    }

    public ConfigOptions setPropertyGroupStyle(class_124 ... style) {
        this.propertyGroupStyle = ConfigOptions.combine(style);
        return this;
    }

    public ConfigOptions setPropertyValueStyle(class_124 ... style) {
        this.propertyValueStyle = ConfigOptions.combine(style);
        return this;
    }

    public ConfigOptions setTooltipStyle(class_124 ... style) {
        this.tooltipStyle = ConfigOptions.combine(style);
        return this;
    }

    private static String combine(class_124 ... style) {
        return Arrays.stream(style).map(Objects::toString).collect(Collectors.joining(""));
    }

    public ConfigOptions setStripTitle(boolean v) {
        this.stripTitle = v;
        return this;
    }

    public ConfigOptions setStripPropertyGroups(boolean v) {
        this.stripPropertyGroups = v;
        return this;
    }

    public ConfigOptions setStripPropertyValues(boolean v) {
        this.stripPropertyValues = v;
        return this;
    }

    public String getTranslationRoot() {
        return this.translationRoot;
    }

    public ConfigOptions setTranslationRoot(String root) {
        this.translationRoot = root;
        return this;
    }

    public int getTooltipWidth() {
        return this.toolTipWidth;
    }

    public ConfigOptions setTooltipWidth(int width) {
        this.toolTipWidth = width;
        return this;
    }

    public class_2561 transformTitle() {
        String txt = Localization.load(this.translationRoot + ".title");
        if (this.stripTitle) {
            txt = ConfigOptions.strip(txt);
        }
        return new class_2585(this.titleStyle + txt);
    }

    public class_2561 transformSubtitle() {
        String txt = Localization.load(this.translationRoot + ".subtitle");
        if (this.stripTitle) {
            txt = ConfigOptions.strip(txt);
        }
        return new class_2585(this.subtitleStyle + txt);
    }

    public class_2561 transformPropertyGroup(String langKey) {
        String txt = Localization.load(langKey);
        if (this.stripPropertyGroups) {
            txt = ConfigOptions.strip(txt);
        }
        return new class_2585(this.propertyGroupStyle + txt);
    }

    public class_2561 transformProperty(String langKey) {
        String txt = Localization.load(langKey);
        if (this.stripPropertyValues) {
            txt = ConfigOptions.strip(txt);
        }
        return new class_2585(this.propertyValueStyle + txt);
    }

    public class_2561[] transformTooltip(List<class_2561> tooltip) {
        ArrayList result = new ArrayList(tooltip.size());
        for (class_2561 e : tooltip) {
            List wrapped = GameUtils.getTextHandler().method_27495((class_5348)e, this.toolTipWidth, class_2583.field_24360).stream().map(l -> new class_2585(this.tooltipStyle + l.getString())).collect(Collectors.toList());
            result.addAll(wrapped);
        }
        return result.toArray(new class_2561[0]);
    }
}

