/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.block;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.lib.IMatcher;
import org.orecruncher.dsurround.lib.block.BlockStateMatcher;

public final class BlockStateMatcherMap<T>
implements Map<IMatcher<class_2680>, T> {
    private final Map<IMatcher<class_2680>, T> map = new Object2ObjectOpenHashMap();
    private Supplier<T> defaultValue = () -> null;

    @Nullable
    public T get(class_2680 state) {
        T result = this.map.get(BlockStateMatcher.create(state));
        if (result == null) {
            result = this.map.get(BlockStateMatcher.asGeneric(state));
        }
        if (result == null) {
            result = this.defaultValue.get();
        }
        return result;
    }

    public void setDefaultValue(Supplier<T> s) {
        this.defaultValue = s;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    @Nullable
    public T get(Object key) {
        return this.map.get(key);
    }

    @Override
    @Nullable
    public T put(IMatcher<class_2680> matcher, T val) {
        return this.map.put(matcher, val);
    }

    @Override
    @Nullable
    public T remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(@NotNull Map<? extends IMatcher<class_2680>, ? extends T> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    @NotNull
    public Set<IMatcher<class_2680>> keySet() {
        return this.map.keySet();
    }

    @Override
    @NotNull
    public Collection<T> values() {
        return this.map.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<IMatcher<class_2680>, T>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public void put(String blockName, T val) {
        try {
            IMatcher<class_2680> result = BlockStateMatcher.create(blockName);
            this.put(result, val);
        }
        catch (Throwable t) {
            Client.LOGGER.error(t, "Unable to put item into map", new Object[0]);
        }
    }

    @Override
    public void put(class_2680 state, T val) {
        IMatcher<class_2680> result = BlockStateMatcher.create(state);
        if (!result.isEmpty()) {
            this.put(result, val);
        }
    }

    @Override
    public void put(class_2248 block, T val) {
        IMatcher<class_2680> result = BlockStateMatcher.create(block);
        if (!result.isEmpty()) {
            this.put(result, val);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.map.entrySet().stream().map(Object::toString).collect(Collectors.joining("\n"))).toString();
    }
}

