/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib.block;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import org.orecruncher.dsurround.lib.IMatcher;
import org.orecruncher.dsurround.lib.block.BlockStateParseException;
import org.orecruncher.dsurround.lib.block.BlockStateParser;
import org.orecruncher.dsurround.lib.block.BlockStateProperties;
import org.orecruncher.dsurround.lib.block.MatchOnBlock;
import org.orecruncher.dsurround.lib.block.MatchOnBlockState;
import org.orecruncher.dsurround.lib.block.MatchOnBlockTag;
import org.orecruncher.dsurround.lib.block.MatchOnMaterial;
import org.orecruncher.dsurround.lib.material.MaterialUtils;

public abstract class BlockStateMatcher
implements IMatcher<class_2680> {
    public static final Codec<IMatcher<class_2680>> CODEC = Codec.STRING.comapFlatMap(BlockStateMatcher::manifest, Object::toString).stable();
    public static final String TAG_TYPE = "#";
    public static final String MATERIAL_TYPE = "@";

    private static DataResult<IMatcher<class_2680>> manifest(String blockId) {
        try {
            return DataResult.success(BlockStateMatcher.create(blockId, true, true));
        }
        catch (Throwable t) {
            return DataResult.error((String)t.getMessage());
        }
    }

    public static IMatcher<class_2680> asGeneric(class_2680 state) {
        return BlockStateMatcher.create(state.method_26204());
    }

    public static IMatcher<class_2680> create(class_2680 state) {
        return new MatchOnBlockState(state);
    }

    public static IMatcher<class_2680> create(class_2248 block) {
        return new MatchOnBlock(block);
    }

    public static IMatcher<class_2680> create(class_3614 material) {
        return new MatchOnMaterial(material);
    }

    public static IMatcher<class_2680> create(String blockId) throws BlockStateParseException {
        return BlockStateMatcher.create(blockId, true, true);
    }

    public static IMatcher<class_2680> create(String blockId, boolean allowTags, boolean allowMaterials) throws BlockStateParseException {
        if (blockId.startsWith(TAG_TYPE)) {
            if (allowTags) {
                return BlockStateMatcher.createTagMatcher(blockId.substring(1));
            }
            throw new BlockStateParseException(String.format("Block id %s is for a tag, and it is not permitted in this context", blockId));
        }
        if (blockId.startsWith(MATERIAL_TYPE)) {
            if (allowMaterials) {
                return BlockStateMatcher.createMaterialMatcher(blockId.substring(1));
            }
            throw new BlockStateParseException(String.format("Block id %s is for material, and it is not permitted in this context", blockId));
        }
        return BlockStateMatcher.createBlockStateMatcher(BlockStateParser.parse(blockId));
    }

    private static BlockStateMatcher createTagMatcher(String tagId) throws BlockStateParseException {
        if (!class_2960.method_20207((String)tagId)) {
            throw new BlockStateParseException(String.format("%s is not a valid block tag", tagId));
        }
        return new MatchOnBlockTag(new class_2960(tagId));
    }

    private static BlockStateMatcher createMaterialMatcher(String materialName) throws BlockStateParseException {
        class_3614 material = MaterialUtils.getMaterial(materialName);
        if (material == null) {
            throw new BlockStateParseException(String.format("Material %s is not known", materialName));
        }
        return new MatchOnMaterial(material);
    }

    private static BlockStateMatcher createBlockStateMatcher(BlockStateParser.ParseResult result) throws BlockStateParseException {
        class_2248 block = result.getBlock();
        class_2680 defaultState = block.method_9564();
        class_2689 container = block.method_9595();
        if (container.method_11662().size() == 1) {
            return new MatchOnBlock(defaultState.method_26204());
        }
        if (!result.hasProperties()) {
            return new MatchOnBlock(block);
        }
        Map<String, String> properties = result.getProperties();
        IdentityHashMap props = new IdentityHashMap(properties.size());
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String s = entry.getKey();
            class_2769 prop = container.method_11663(s);
            if (prop != null) {
                Optional optional = prop.method_11900(entry.getValue());
                if (optional.isPresent()) {
                    props.put(prop, (Comparable)optional.get());
                    continue;
                }
                String msg = String.format("Value '%s' for property '%s' not found for block '%s'", entry.getValue(), s, result.getBlockName());
                throw new BlockStateParseException(msg);
            }
            String msg = String.format("Property %s not found for block %s", s, result.getBlockName());
            throw new BlockStateParseException(msg);
        }
        return new MatchOnBlockState(defaultState, new BlockStateProperties(props));
    }

    @Override
    public abstract boolean isEmpty();

    @Override
    public abstract boolean match(class_2680 var1);
}

