/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.random.XorShiftRandom;

public class WeightTable<T> {
    private static final int DEFAULT_ARRAY_SIZE = 8;
    protected static final Random RANDOM = XorShiftRandom.current();
    protected int[] weightSegment = new int[8];
    protected Object[] item = new Object[8];
    protected int maxEntryIdx = 0;
    protected int totalWeight = 0;

    public WeightTable() {
    }

    public WeightTable(Collection<? extends IItem<T>> input) {
        for (IItem<T> i : input) {
            this.add(i.getItem(), i.getWeight());
        }
    }

    public void add(T e, int weight) {
        if (weight <= 0) {
            return;
        }
        if (this.maxEntryIdx == this.weightSegment.length) {
            this.weightSegment = Arrays.copyOf(this.weightSegment, this.weightSegment.length * 2);
            this.item = Arrays.copyOf(this.item, this.item.length * 2);
        }
        this.totalWeight += weight;
        this.weightSegment[this.maxEntryIdx] = this.totalWeight;
        this.item[this.maxEntryIdx] = e;
        ++this.maxEntryIdx;
    }

    public void add(IItem<T> entry) {
        this.add(entry.getItem(), entry.getWeight());
    }

    public int size() {
        return this.item.length;
    }

    @Nullable
    public T next() {
        if (this.totalWeight <= 0) {
            return null;
        }
        if (this.item.length == 1) {
            return (T)this.item[0];
        }
        int targetWeight = RANDOM.nextInt(this.totalWeight);
        for (int i = 0; i < this.maxEntryIdx; ++i) {
            if (targetWeight >= this.weightSegment[i]) continue;
            return (T)this.item[i];
        }
        throw new RuntimeException("Bad weight table - ran off the end");
    }

    @Nullable
    public static <T> T makeSelection(List<? extends IItem<T>> input) {
        if (input.size() == 0) {
            return null;
        }
        if (input.size() == 1) {
            return input.get(0).getItem();
        }
        return new WeightTable<T>(input).next();
    }

    @Nullable
    public static <T> T makeSelection(Stream<? extends IItem<T>> inputStream) {
        WeightTable<T> table = null;
        Iterator itr = inputStream.iterator();
        while (itr.hasNext()) {
            if (table == null) {
                table = new WeightTable<T>();
            }
            table.add((IItem)itr.next());
        }
        return table != null ? (T)table.next() : null;
    }

    public static interface IItem<T> {
        public int getWeight();

        public T getItem();
    }
}

