/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.Client;

public class FrameworkUtils {
    public static Optional<ModContainer> getModContainer(String namespace) {
        return FabricLoader.getInstance().getModContainer(namespace);
    }

    public static Optional<ModCustomData> getModCustomData(String modId, String dataKey) {
        Optional container = FabricLoader.getInstance().getModContainer(modId);
        if (container.isEmpty()) {
            return Optional.empty();
        }
        CustomValue property = ((ModContainer)container.get()).getMetadata().getCustomValue(dataKey);
        if (property != null && property.getType() == CustomValue.CvType.OBJECT) {
            ModCustomData data = new ModCustomData(property.getAsObject());
            return Optional.of(data);
        }
        return Optional.empty();
    }

    @Nullable
    public static String getModDisplayName(String namespace) {
        Optional container = FabricLoader.getInstance().getModContainer(namespace);
        return container.map(modContainer -> modContainer.getMetadata().getName()).orElse(null);
    }

    @Nullable
    public static Version getModVersion(String namespace) {
        Optional container = FabricLoader.getInstance().getModContainer(namespace);
        return container.map(modContainer -> modContainer.getMetadata().getVersion()).orElse(null);
    }

    public static boolean isModLoaded(String namespace) {
        return FabricLoader.getInstance().isModLoaded(namespace);
    }

    public static String getModBranding(String namespace) {
        Optional container = FabricLoader.getInstance().getModContainer(namespace);
        if (container.isPresent()) {
            ModMetadata data = ((ModContainer)container.get()).getMetadata();
            return String.format("%s v%s", data.getName(), data.getVersion());
        }
        return "";
    }

    public static Collection<String> getModIdList(boolean loadedOnly) {
        return FabricLoader.getInstance().getAllMods().stream().map(container -> container.getMetadata().getId()).filter(name -> !loadedOnly || FabricLoader.getInstance().isModLoaded(name)).collect(Collectors.toList());
    }

    public static Path getConfigPath(String modId) {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        Path configPath = configDir.resolve(Objects.requireNonNull(modId));
        if (Files.notExists(configPath, new LinkOption[0])) {
            try {
                Files.createDirectory(configPath, new FileAttribute[0]);
            }
            catch (IOException ex) {
                Client.LOGGER.error(ex, "Unable to create directory path %s", configPath.toString());
                configPath = configDir;
            }
        }
        return configPath;
    }

    public static class ModCustomData {
        private final CustomValue.CvObject dataMap;

        ModCustomData(CustomValue.CvObject data) {
            this.dataMap = data;
        }

        public CustomValue get(String keyPath) {
            if (Strings.isNullOrEmpty((String)keyPath)) {
                return this.dataMap;
            }
            String[] segments = keyPath.split("\\.");
            return ModCustomData.find((CustomValue)this.dataMap, segments, 0);
        }

        @Nullable
        private static CustomValue find(CustomValue cv, String[] pathSegments, int idx) {
            int maxLevel = pathSegments.length - 1;
            if (idx > maxLevel || cv.getType() != CustomValue.CvType.OBJECT) {
                return null;
            }
            CustomValue value = cv.getAsObject().get(pathSegments[idx]);
            if (value == null) {
                return null;
            }
            if (idx == maxLevel) {
                return value;
            }
            return ModCustomData.find(value, pathSegments, idx + 1);
        }

        public String getString(String path) {
            CustomValue value = this.get(path);
            if (value != null && value.getType() == CustomValue.CvType.STRING) {
                return value.getAsString();
            }
            return null;
        }
    }
}

