/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib;

import net.minecraft.class_1937;
import org.orecruncher.dsurround.lib.Localization;

public enum DayCycle {
    NO_SKY(false, "NoSky"),
    SUNRISE(false, "Sunrise"),
    SUNSET(true, "Sunset"),
    DAYTIME(false, "Daytime"),
    NIGHTTIME(true, "Nighttime");

    private static final float DAYTIME_THRESHOLD = 0.8f;
    private static final float SUNRISE_THRESHOLD = 0.76f;
    private static final float NIGHTTIME_THRESHOLD = 0.26f;
    private static final float SUNSET_THRESHOLD = 0.22f;
    private final boolean auroraVisible;
    private final String localizeString;

    private DayCycle(boolean auroraVisible, String localName) {
        this.auroraVisible = auroraVisible;
        this.localizeString = "dsurround.format." + localName;
    }

    public static boolean isDaytime(class_1937 world) {
        return DayCycle.getCycle(world) == DAYTIME;
    }

    public static boolean isNighttime(class_1937 world) {
        return DayCycle.getCycle(world) == NIGHTTIME;
    }

    public static boolean isSunrise(class_1937 world) {
        return DayCycle.getCycle(world) == SUNRISE;
    }

    public static boolean isSunset(class_1937 world) {
        return DayCycle.getCycle(world) == SUNSET;
    }

    public static DayCycle getCycle(class_1937 world) {
        if (world.method_8597().method_27998() || !world.method_8597().method_12491()) {
            return NO_SKY;
        }
        float angle = world.method_30274(0.0f);
        if (angle > 0.8f) {
            return DAYTIME;
        }
        if (angle > 0.76f) {
            return SUNRISE;
        }
        if (angle > 0.26f) {
            return NIGHTTIME;
        }
        if (angle > 0.22f) {
            return SUNSET;
        }
        return DAYTIME;
    }

    public static float getMoonSize(class_1937 world) {
        return world.method_30272();
    }

    public static boolean isAuroraInvisible(class_1937 world) {
        return !DayCycle.getCycle(world).isAuroraVisible();
    }

    public boolean isAuroraVisible() {
        return this.auroraVisible;
    }

    public String getFormattedName() {
        return Localization.load(this.localizeString);
    }
}

